/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2025 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.archetype.test.builder.supplier.delivery;

import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.supplier.TestSupplierActVerifier;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.service.archetype.ArchetypeService;

/**
 * Verifies  <em>act.supplierDelivery</em> instances match that expected, for testing purposes.
 *
 * @author Tim Anderson
 */
public class TestDeliveryVerifier extends TestSupplierActVerifier<TestDeliveryVerifier> {

    /**
     * The expected supplier invoice id.
     */
    private ValueStrategy supplierInvoiceId = ValueStrategy.unset();

    /**
     * The expected supplier notes.
     */
    private ValueStrategy supplierNotes = ValueStrategy.unset();

    /**
     * Constructs a {@link TestDeliveryVerifier}.
     *
     * @param service the archetype service
     */
    public TestDeliveryVerifier(ArchetypeService service) {
        super(service);
    }

    /**
     * Sets the expected supplier invoice identifier.
     *
     * @param supplierInvoiceId the expected supplier invoice identifier
     * @return this
     */
    public TestDeliveryVerifier supplierInvoiceId(String supplierInvoiceId) {
        this.supplierInvoiceId = ValueStrategy.value(supplierInvoiceId);
        return this;
    }

    public TestDeliveryVerifier supplierNotes(String notes) {
        return this;
    }

    /**
     * Verifies an object matches that expected.
     *
     * @param object the object to verify
     * @param bean   a bean wrapping the object
     */
    @Override
    protected void verify(FinancialAct object, IMObjectBean bean) {
        super.verify(object, bean);
        checkIdentityEquals(supplierInvoiceId, bean, "supplierInvoiceId");
        checkEquals(supplierNotes, bean.getString("supplierNotes"));
    }
}
