/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2021 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.archetype.rules.workflow;


/**
 * Schedule archetype short names.
 *
 * @author Tim Anderson
 */
public class ScheduleArchetypes {

    /**
     * Organisation schedule archetype short name.
     */
    public static final String ORGANISATION_SCHEDULE = "party.organisationSchedule";

    /**
     * Organisation work list archetype short name.
     */
    public static final String ORGANISATION_WORKLIST = "party.organisationWorkList";

    /**
     * The appointment archetype short name.
     */
    public static final String APPOINTMENT = "act.customerAppointment";

    /**
     * The calendar event series archetype short name.
     */
    public static final String CALENDAR_EVENT_SERIES = "act.calendarEventSeries";

    /**
     * The task archetype short name.
     */
    public static final String TASK = "act.customerTask";

    /**
     * Appointment type archetype short name.
     */
    public static final String APPOINTMENT_TYPE = "entity.appointmentType";

    /**
     * Task type archetype short name.
     */
    public static final String TASK_TYPE = "entity.taskType";

    /**
     * Schedule-appointment type entity relationship archetype short name.
     */
    public static final String SCHEDULE_APPOINTMENT_TYPE_RELATIONSHIP = "entityRelationship.scheduleAppointmentType";

    /**
     * Schedule-work list entity relationship archetype short name.
     */
    public static final String SCHEDULE_WORKLIST_RELATIONSHIP = "entityRelationship.scheduleWorkList";

    /**
     * Schedule-template entity relationship archetype short name.
     */
    public static final String SCHEDULE_TEMPLATE_RELATIONSHIP = "entityRelationship.scheduleDocumentTemplate";

    /**
     * Worklist-task type entity relationship archetype short name.
     */
    public static final String WORKLIST_TASK_TYPE_RELATIONSHIP = "entityRelationship.worklistTaskType";

    /**
     * Worklist-template entity relationship archetype short name.
     */
    public static final String WORKLIST_TEMPLATE_RELATIONSHIP = "entityRelationship.worklistDocumentTemplate";

    /**
     * The appointment type participation archetype short name.
     */
    public static final String APPOINTMENT_TYPE_PARTICIPATION = "participation.appointmentType";

    /**
     * Schedule participation archetype short name.
     */
    public static final String SCHEDULE_PARTICIPATION = "participation.schedule";

    /**
     * Worklist participation archetype short name.
     */
    public static final String WORKLIST_PARTICIPATION = "participation.worklist";

    /**
     * Task type participation archetype short name.
     */
    public static final String TASK_TYPE_PARTICIPATION = "participation.taskType";

    /**
     * Appointment schedule view.
     */
    public static final String SCHEDULE_VIEW = "entity.organisationScheduleView";

    /**
     * Work list view.
     */
    public static final String WORK_LIST_VIEW = "entity.organisationWorkListView";

    /**
     * Visit reason archetype short name.
     */
    public static String VISIT_REASON = "lookup.visitReason";

    /**
     * Visit reason archetypes (i.e. includes lookup.visitReason and lookup.visitReasonVeNom).
     */
    public static String VISIT_REASONS = "lookup.visitReason*";

    /**
     * Cage type short name.
     */
    public static final String CAGE_TYPE = "entity.cageType";

    /**
     * Calendar block archetype short name.
     */
    public static final String CALENDAR_BLOCK = "act.calendarBlock";

    /**
     * Calendar block type archetype short name.
     */
    public static final String CALENDAR_BLOCK_TYPE = "entity.calendarBlockType";

    /**
     * Calendar event archetype.
     */
    public static final String CALENDAR_EVENT = "act.calendarEvent";

    /**
     * Roster area.
     */
    public static final String ROSTER_AREA = "entity.rosterArea";

    /**
     * Roster event archetype.
     */
    public static final String ROSTER_EVENT = "act.rosterEvent";

    /**
     * Roster area participation.
     */
    public static final String AREA_PARTICIPATION = "participation.rosterArea";

    /**
     * Default constructor.
     */
    private ScheduleArchetypes() {
        // no-op
    }
}


