/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2024 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.archetype.rules.product;


/**
 * Product archetype short names.
 *
 * @author Tim Anderson
 */
public class ProductArchetypes {

    /**
     * Medication short name.
     */
    public static final String MEDICATION = "product.medication";

    /**
     * Merchandise short name.
     */
    public static final String MERCHANDISE = "product.merchandise";

    /**
     * Service short name.
     */
    public static final String SERVICE = "product.service";

    /**
     * Template short name.
     */
    public static final String TEMPLATE = "product.template";

    /**
     * Price template short name.
     */
    public static final String PRICE_TEMPLATE = "product.priceTemplate";

    /**
     * All product archetypes.
     */
    public static final String PRODUCTS = "product.*";

    /**
     * Product participation short name.
     */
    public static final String PRODUCT_PARTICIPATION = "participation.product";

    /**
     * Medication participation short name.
     */
    public static final String MEDICATION_PARTICIPATION = "participation.medication";

    /**
     * Product unit price short name.
     */
    public static final String UNIT_PRICE = "productPrice.unitPrice";

    /**
     * Product fixed price short name.
     */
    public static final String FIXED_PRICE = "productPrice.fixedPrice";

    /**
     * Pricing group short name.
     */
    public static final String PRICING_GROUP = "lookup.pricingGroup";

    /**
     * Product-supplier relationship short name.
     */
    public static final String PRODUCT_SUPPLIER_RELATIONSHIP = "entityLink.productSupplier";

    /**
     * Product-reminder relationship archetype.
     */
    public static final String PRODUCT_REMINDER_RELATIONSHIP = "entityLink.productReminder";

    /**
     * Product-task relationship archetype.
     */
    public static final String PRODUCT_TASK_RELATIONSHIP = "entityLink.productTask";

    /**
     * Product type short name.
     */
    public static final String PRODUCT_TYPE = "entity.productType";

    /**
     * Product batch short name.
     */
    public static final String PRODUCT_BATCH = "entity.productBatch";

    /**
     * Template product include relationship
     */
    public static final String PRODUCT_INCLUDES = "entityLink.productIncludes";

    /**
     * Product dose short name.
     */
    public static final String DOSE = "entity.productDose";

    /**
     * The drug schedule.
     */
    public static final String DRUG_SCHEDULE = "lookup.productDrugSchedule";

    /**
     * Service ratio calendar.
     */
    public static final String SERVICE_RATIO_CALENDAR = "entity.calendarServiceRatio";

    /**
     * Unit-of-measure lookup.
     */
    public static final String UNIT_OF_MEASURE = "lookup.uom";

    /**
     * Demographic update lookup.
     */
    public static final String DEMOGRAPHIC_UPDATE = "lookup.demographicUpdate";

    /**
     * Default constructor.
     */
    private ProductArchetypes() {
        // no-op
    }
}
