/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2024 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.archetype.rules.patient.reminder;

import org.openvpms.component.model.document.Document;

import java.util.Date;
import java.util.List;

/**
 * Exports reminders.
 *
 * @author Tim Anderson
 */
public interface ReminderExporter {

    /**
     * Exports reminders.
     *
     * @param reminders the reminders to export
     * @param date      the date to use for determining the next pending appointment
     * @return the exported reminders
     */
    Document export(List<ReminderEvent> reminders, Date date);
}