/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2025 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.archetype.rules.finance.paymentprocessor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * Payment processor archetypes.
 *
 * @author Tim Anderson
 */
public class PaymentProcessorArchetypes {

    /**
     * Payment processors.
     */
    public static final String PAYMENT_PROCESSORS = "entity.paymentProcessor*";

    /**
     * The payment processor payment.
     */
    public static final String PAYMENT = "act.paymentProcessorPayment";

    /**
     * The payment processor refund.
     */
    public static final String REFUND = "act.paymentProcessorRefund";

    /**
     * Payment processor transactions.
     */
    public static final List<String> TRANSACTIONS = Collections.unmodifiableList(Arrays.asList(PAYMENT, REFUND));

    /**
     * Processor transaction identifiers.
     */
    public static final String TRANSACTION_IDS = "actIdentity.paymentProcessorTransaction*";

    /**
     * Parent transaction identifier archetype.
     */
    public static final String PARENT_ID = "actIdentity.paymentProcessorParentId";

    /**
     * Default constructor.
     */
    private PaymentProcessorArchetypes() {
    }

}
