/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Objects;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.functors.AllPredicate;
import org.joda.time.Period;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.AppointmentService;
import org.openvpms.archetype.rules.workflow.ClinicianSchedule;
import org.openvpms.archetype.rules.workflow.FreeSlotIterator;
import org.openvpms.archetype.rules.workflow.FreeSlotIterators;
import org.openvpms.archetype.rules.workflow.Slot;
import org.openvpms.archetype.rules.workflow.roster.RosterService;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.user.User;

public class FreeSlotQuery {
    private final IArchetypeService service;
    private final AppointmentService appointmentService;
    private final RosterService rosterService;
    private final AppointmentRules rules;
    private Date fromDate;
    private Date toDate;
    private Period fromTime;
    private Period toTime;
    private Entity[] schedules = new Entity[0];
    private Reference cageType;
    private User clinician;
    private long minSlotSize = -1L;

    public FreeSlotQuery(IArchetypeService service, AppointmentService appointmentService, RosterService rosterService, AppointmentRules rules) {
        this.service = service;
        this.appointmentService = appointmentService;
        this.rosterService = rosterService;
        this.rules = rules;
    }

    public void setFromDate(Date from) {
        this.fromDate = from;
    }

    public void setToDate(Date to) {
        this.toDate = to;
    }

    public void setFromTime(Period time) {
        this.fromTime = time;
    }

    public void setToTime(Period time) {
        this.toTime = time;
    }

    public void setSchedules(Entity ... schedules) {
        this.schedules = schedules;
    }

    public void setCageType(Entity cageType) {
        this.cageType = cageType != null ? cageType.getObjectReference() : null;
    }

    public void setClinician(User clinician) {
        this.clinician = clinician;
    }

    public void setMinSlotSize(int size, DateUnits units) {
        switch (units) {
            case WEEKS: {
                this.minSlotSize = (long)size * 86400000L * 7L;
                break;
            }
            case DAYS: {
                this.minSlotSize = (long)size * 86400000L;
                break;
            }
            case HOURS: {
                this.minSlotSize = (long)size * 3600000L;
                break;
            }
            case MINUTES: {
                this.minSlotSize = (long)size * 60000L;
                break;
            }
            default: {
                this.minSlotSize = 0L;
            }
        }
    }

    public Iterator<Slot> query() {
        if (this.fromDate != null && this.toDate != null && this.schedules.length > 0) {
            Predicate<Slot> predicate = this.getPredicate();
            ArrayList<FreeSlotIterator> list = new ArrayList<FreeSlotIterator>();
            ClinicianSchedule clinicianSchedule = null;
            if (this.clinician != null) {
                clinicianSchedule = new ClinicianSchedule(this.clinician, this.fromDate, DateRules.getNextDate(this.toDate), this.service, this.rosterService, this.appointmentService, this.rules);
            }
            for (Entity schedule : this.schedules) {
                if (!this.isSelected(schedule)) continue;
                list.add(new FreeSlotIterator(schedule, this.fromDate, this.toDate, this.fromTime, this.toTime, clinicianSchedule, this.service));
            }
            return new FreeSlotIterators(list, predicate);
        }
        return Collections.emptyIterator();
    }

    private boolean isSelected(Entity schedule) {
        boolean selected = true;
        if (this.cageType != null) {
            IMObjectBean bean = this.service.getBean((IMObject)schedule);
            selected = Objects.equals(this.cageType, bean.getTargetRef("cageType"));
        }
        return selected;
    }

    private Predicate<Slot> getPredicate() {
        ArrayList<SlotSizePredicate> predicates = new ArrayList<SlotSizePredicate>();
        if (this.minSlotSize > 0L) {
            predicates.add(new SlotSizePredicate());
        }
        return AllPredicate.allPredicate(predicates);
    }

    private class SlotSizePredicate
    implements Predicate<Slot> {
        private SlotSizePredicate() {
        }

        public boolean evaluate(Slot slot) {
            long duration = slot.getEndTime().getTime() - slot.getStartTime().getTime();
            return duration >= FreeSlotQuery.this.minSlotSize;
        }
    }
}

