/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow;

import java.util.Date;
import java.util.List;
import org.ehcache.Cache;
import org.openvpms.archetype.rules.workflow.ScheduleEventCache;
import org.openvpms.archetype.rules.workflow.ScheduleEventFactory;
import org.openvpms.archetype.rules.workflow.ScheduleEvents;
import org.openvpms.archetype.rules.workflow.ScheduleService;
import org.openvpms.component.business.service.archetype.AbstractArchetypeServiceListener;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.IArchetypeServiceListener;
import org.openvpms.component.business.service.cache.EhCacheable;
import org.openvpms.component.business.service.cache.EhcacheManager;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.util.PropertySet;
import org.springframework.beans.factory.DisposableBean;

public abstract class AbstractScheduleService
implements ScheduleService,
DisposableBean,
EhCacheable {
    private final IArchetypeService service;
    private final ScheduleEventCache cache;
    private final ScheduleEventFactory factory;
    private final String[] eventArchetypes;
    private final IArchetypeServiceListener listener;

    protected AbstractScheduleService(String[] eventArchetypes, IArchetypeService service, EhcacheManager cacheManager, String cacheName, ScheduleEventFactory factory) {
        this.service = service;
        this.factory = factory;
        this.cache = this.createScheduleEventCache(cacheManager, cacheName, factory);
        this.eventArchetypes = eventArchetypes;
        this.listener = new AbstractArchetypeServiceListener(){

            public void saved(IMObject object) {
                AbstractScheduleService.this.addEvent((Act)object);
            }

            public void removed(IMObject object) {
                AbstractScheduleService.this.removeEvent((Act)object);
            }
        };
        for (String shortName : eventArchetypes) {
            service.addListener(shortName, this.listener);
        }
    }

    public Cache getCache() {
        return this.cache.getCache();
    }

    public void clear() {
        this.cache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        try {
            for (String shortName : this.eventArchetypes) {
                this.service.removeListener(shortName, this.listener);
            }
        }
        finally {
            this.cache.clear();
        }
    }

    public String[] getEventArchetypes() {
        return this.eventArchetypes;
    }

    @Override
    public List<PropertySet> getEvents(Entity schedule, Date day) {
        return this.cache.getEvents(schedule, day).getEvents();
    }

    @Override
    public ScheduleEvents getScheduleEvents(Entity schedule, Date day) {
        return this.cache.getEvents(schedule, day);
    }

    @Override
    public long getModHash(Entity schedule, Date day) {
        return this.cache.getModHash(schedule, day);
    }

    @Override
    public List<PropertySet> getEvents(Entity schedule, Date from, Date to) {
        return this.getScheduleEvents(schedule, from, to).getEvents();
    }

    @Override
    public ScheduleEvents getScheduleEvents(Entity schedule, Date from, Date to) {
        return this.cache.getEvents(schedule, from, to);
    }

    @Override
    public long getModHash(Entity schedule, Date from, Date to) {
        return this.cache.getModHash(schedule, from, to);
    }

    protected List<PropertySet> getCached(Reference schedule, Date day) {
        return this.cache.getCached(schedule, day);
    }

    protected IArchetypeService getService() {
        return this.service;
    }

    protected ScheduleEventFactory getEventFactory() {
        return this.factory;
    }

    protected void addEvent(Act event) {
        this.cache.addEvent(event);
    }

    protected void removeEvent(Act event) {
        this.cache.removeEvent(event);
    }

    protected void clearCache() {
        this.cache.clear();
    }

    ScheduleEventCache createScheduleEventCache(EhcacheManager cacheManager, String cacheName, ScheduleEventFactory factory) {
        return new ScheduleEventCache(cacheManager, cacheName, factory);
    }
}

