/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.stock;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.rules.stock.StockRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;

public class StockUpdater {
    private final IArchetypeService service;
    private final StockRules rules;

    public StockUpdater(IArchetypeService service) {
        this.service = service;
        this.rules = new StockRules(service);
    }

    public void update(Act act) {
        if ("POSTED".equals(act.getStatus())) {
            Set<IMObject> toSave = null;
            if (TypeHelper.isA((IMObject)act, (String)"act.stockTransfer")) {
                toSave = this.transferStock(act);
            } else if (TypeHelper.isA((IMObject)act, (String)"act.stockAdjust")) {
                toSave = this.adjustStock(act);
            }
            if (toSave != null && !toSave.isEmpty()) {
                this.service.save(toSave);
            }
        }
    }

    private Set<IMObject> transferStock(Act act) {
        HashSet<IMObject> toSave = new HashSet<IMObject>();
        IMObjectBean bean = this.service.getBean((IMObject)act);
        Party from = (Party)bean.getTarget("stockLocation", Party.class);
        Party to = (Party)bean.getTarget("to", Party.class);
        if (from != null && to != null) {
            for (Act item : bean.getTargets("items", Act.class)) {
                toSave.addAll(this.transferStock(item, from, to));
            }
        }
        return toSave;
    }

    private List<IMObject> transferStock(Act item, Party from, Party to) {
        IMObjectBean itemBean = this.service.getBean((IMObject)item);
        Product product = (Product)itemBean.getTarget("product", Product.class);
        BigDecimal quantity = itemBean.getBigDecimal("quantity", BigDecimal.ZERO);
        List<IMObject> result = product != null && quantity.compareTo(BigDecimal.ZERO) != 0 ? this.rules.transfer(product, from, to, quantity) : Collections.emptyList();
        return result;
    }

    private Set<IMObject> adjustStock(Act act) {
        HashSet<IMObject> toSave = new HashSet<IMObject>();
        IMObjectBean bean = this.service.getBean((IMObject)act);
        Party stockLocation = (Party)bean.getTarget("stockLocation", Party.class);
        if (stockLocation != null) {
            for (Act item : bean.getTargets("items", Act.class)) {
                toSave.addAll(this.adjustStock(item, stockLocation));
            }
        }
        return toSave;
    }

    private Set<IMObject> adjustStock(Act item, Party stockLocation) {
        HashSet<IMObject> toSave = new HashSet<IMObject>();
        IMObjectBean itemBean = this.service.getBean((IMObject)item);
        Product product = (Product)itemBean.getTarget("product", Product.class);
        BigDecimal quantity = itemBean.getBigDecimal("quantity", BigDecimal.ZERO);
        if (product != null && quantity.compareTo(BigDecimal.ZERO) != 0) {
            toSave.addAll(this.rules.calcStock(product, stockLocation.getObjectReference(), quantity));
        }
        return toSave;
    }
}

