/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.security.FirewallEntry;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

public class FirewallSettings {
    private final IMObjectBean settings;

    public FirewallSettings(Entity settings, ArchetypeService service) {
        this(service.getBean((IMObject)settings));
    }

    public FirewallSettings(IMObjectBean settings) {
        this.settings = settings;
    }

    public AccessType getAccessType() {
        return AccessType.valueOf(this.settings.getString("accessType", AccessType.UNRESTRICTED.toString()));
    }

    public void setAccessType(AccessType accessType) {
        this.settings.setValue("accessType", (Object)accessType.toString());
    }

    public boolean isMultifactorAuthenticationEnabled() {
        return this.settings.getBoolean("enableMfa");
    }

    public void setMultifactorAuthenticationEnabled(boolean enable) {
        this.settings.setValue("enableMfa", (Object)enable);
    }

    public List<FirewallEntry> getAllowedAddresses() {
        ArrayList<FirewallEntry> list = new ArrayList<FirewallEntry>();
        for (String line : this.getAllowedLines()) {
            FirewallEntry entry = this.parse(line);
            if (entry == null) continue;
            list.add(entry);
        }
        return list;
    }

    public void setAllowedAddresses(List<FirewallEntry> allowed) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        AddressNode bucket = AddressNode.create(this.settings, i);
        for (FirewallEntry entry : allowed) {
            String line = this.encode(entry);
            if (buffer.length() + line.length() < bucket.getMaxLength()) {
                buffer.append(line);
                continue;
            }
            bucket.setAddresses(buffer.toString());
            bucket = AddressNode.create(this.settings, ++i);
            buffer = new StringBuilder(line);
        }
        bucket.setAddresses(buffer.toString());
        boolean done = false;
        while (!done) {
            if ((bucket = AddressNode.createIfExists(this.settings, ++i)) != null) {
                bucket.setAddresses(null);
                continue;
            }
            done = true;
        }
    }

    public Entity getSettings() {
        return (Entity)this.settings.getObject(Entity.class);
    }

    private List<String> getAllowedLines() {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        boolean done = false;
        while (!done) {
            AddressNode bucket = AddressNode.createIfExists(this.settings, i);
            if (bucket != null) {
                result.addAll(bucket.getAddresses());
                ++i;
                continue;
            }
            done = true;
        }
        return result;
    }

    private String encode(FirewallEntry entry) {
        StringBuilder line = new StringBuilder();
        String address = StringUtils.strip((String)entry.getAddress());
        String description = StringUtils.strip((String)entry.getDescription());
        line.append(address).append(' ').append(entry.isActive() ? (char)'1' : '0');
        if (description != null) {
            line.append(' ').append(description);
        }
        line.append('\n');
        return line.toString();
    }

    private FirewallEntry parse(String line) {
        FirewallEntry result = null;
        int first = line.indexOf(32);
        if (first != -1) {
            boolean active;
            String address = line.substring(0, first);
            int second = line.indexOf(32, first + 1);
            String description = null;
            if (second != -1) {
                boolean bl = active = Integer.parseInt(line.substring(first + 1, second)) > 0;
                if (second + 1 < line.length()) {
                    description = line.substring(second + 1);
                }
            } else {
                active = Integer.parseInt(line.substring(first + 1)) > 0;
            }
            result = new FirewallEntry(address, active, description);
        }
        return result;
    }

    private static class AddressNode {
        private final IMObjectBean bean;
        private final String node;
        private final int maxLength;

        public AddressNode(IMObjectBean bean, String node) {
            this.bean = bean;
            this.node = node;
            this.maxLength = bean.getMaxLength(node);
        }

        public List<String> getAddresses() {
            String addresses = this.bean.getString(this.node);
            List<String> result = !StringUtils.isEmpty((CharSequence)addresses) ? Arrays.asList(StringUtils.split((String)addresses, (char)'\n')) : Collections.emptyList();
            return result;
        }

        public void setAddresses(String addresses) {
            this.bean.setValue(this.node, (Object)addresses);
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public static AddressNode create(IMObjectBean bean, int count) {
            AddressNode result = AddressNode.createIfExists(bean, count);
            if (result == null) {
                throw new IllegalArgumentException("No node for count: " + count);
            }
            return result;
        }

        public static AddressNode createIfExists(IMObjectBean bean, int count) {
            String node = "allowed" + count;
            return bean.hasNode(node) ? new AddressNode(bean, node) : null;
        }
    }

    public static enum AccessType {
        UNRESTRICTED,
        ALLOWED_ONLY,
        ALLOWED_USER;

    }
}

