/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product.io;

import java.math.BigDecimal;
import java.util.List;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.product.io.PriceData;
import org.openvpms.archetype.rules.product.io.ProductData;
import org.openvpms.archetype.rules.product.io.ProductDataComparator;
import org.openvpms.archetype.rules.product.io.ProductIOHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.service.archetype.ArchetypeService;

class ProductUpdater {
    private final ArchetypeService service;
    private final ProductPriceRules rules;
    private final ProductDataComparator comparer;

    public ProductUpdater(ProductPriceRules rules, ArchetypeService service) {
        this.rules = rules;
        this.service = service;
        this.comparer = new ProductDataComparator(rules, service);
    }

    public void update(Product product, ProductData data) {
        ProductData changes = this.comparer.compare(product, data);
        if (changes != null) {
            List<ProductPrice> unitPrices = this.comparer.getUnitPrices(product, changes);
            List<ProductPrice> fixedPrices = this.comparer.getFixedPrices(product, changes);
            this.updateProduct(product, changes.getUnitPrices(), unitPrices);
            this.updateProduct(product, changes.getFixedPrices(), fixedPrices);
            IMObjectBean bean = this.service.getBean((IMObject)product);
            if (bean.hasNode("printedName")) {
                bean.setValue("printedName", (Object)data.getPrintedName());
            }
        }
    }

    private void updateProduct(Product product, List<PriceData> prices, List<ProductPrice> existing) {
        for (PriceData price : prices) {
            if (price.getId() != -1L) {
                ProductPrice match = ProductIOHelper.getPrice(price, existing);
                this.updatePrice(match, price);
                continue;
            }
            ProductPrice newPrice = (ProductPrice)this.service.create(price.getShortName(), ProductPrice.class);
            this.updatePrice(newPrice, price);
            product.addProductPrice(newPrice);
        }
    }

    private void updatePrice(ProductPrice price, PriceData data) {
        BigDecimal markup = this.rules.getMarkup(data.getCost(), data.getPrice());
        IMObjectBean bean = this.service.getBean((IMObject)price);
        price.setPrice(data.getPrice());
        price.setFromDate(data.getFrom());
        price.setToDate(data.getTo());
        bean.setValue("cost", (Object)data.getCost());
        bean.setValue("markup", (Object)markup);
        bean.setValue("maxDiscount", (Object)data.getMaxDiscount());
        if (bean.hasNode("default")) {
            bean.setValue("default", (Object)data.isDefault());
        }
    }
}

