/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.prefs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.openvpms.archetype.rules.prefs.PreferenceGroup;
import org.openvpms.archetype.rules.prefs.PreferenceManager;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

class PreferencesImpl
implements Preferences {
    protected static final String GROUPS = "groups";
    private final Reference party;
    private final Reference source;
    private final List<PreferenceGroup> groups = new ArrayList<PreferenceGroup>();
    private final IArchetypeService service;
    private final PlatformTransactionManager transactionManager;
    private IMObjectBean bean;
    static final String TARGET = "target";
    static final String USER = "user";
    private static final Logger log = LoggerFactory.getLogger(PreferencesImpl.class);

    public PreferencesImpl(Reference party, Reference source, Entity preferences, IArchetypeService service) {
        this(party, source, preferences, service, null);
    }

    public PreferencesImpl(Reference party, Reference source, Entity preferences, IArchetypeService service, PlatformTransactionManager transactionManager) {
        this.party = party;
        this.source = source;
        this.bean = service.getBean((IMObject)preferences);
        this.service = service;
        this.transactionManager = transactionManager;
    }

    @Override
    public Object getPreference(String groupName, String name, Object defaultValue) {
        Object value = this.getGroup(groupName).get(name);
        return value != null ? value : defaultValue;
    }

    @Override
    public void setPreference(String groupName, String name, Object value) {
        boolean save = this.transactionManager != null;
        this.setPreference(groupName, name, value, save);
    }

    @Override
    public boolean getBoolean(String groupName, String name, boolean defaultValue) {
        return this.getGroup(groupName).getBoolean(name, defaultValue);
    }

    @Override
    public int getInt(String groupName, String name, int defaultValue) {
        return this.getGroup(groupName).getInt(name, defaultValue);
    }

    @Override
    public long getLong(String groupName, String name, long defaultValue) {
        return this.getGroup(groupName).getLong(name, defaultValue);
    }

    @Override
    public String getString(String groupName, String name, String defaultValue) {
        return this.getGroup(groupName).getString(name, defaultValue);
    }

    @Override
    public Reference getReference(String groupName, String name, Reference defaultValue) {
        IMObjectReference result = this.getGroup(groupName).getReference(name);
        return result != null ? result : defaultValue;
    }

    @Override
    public Set<String> getGroupNames() {
        String[] relationshipTypes = this.getRelationshipTypes();
        return this.getGroupNames(relationshipTypes);
    }

    @Override
    public Set<String> getNames(String groupName) {
        PreferenceGroup group = this.getGroup(groupName);
        return group.getNames();
    }

    protected Set<String> getGroupNames(String[] relationshipTypes) {
        return new LinkedHashSet<String>(Arrays.asList(DescriptorHelper.getNodeShortNames((String[])relationshipTypes, (String)TARGET, (ArchetypeService)this.service)));
    }

    protected String[] getRelationshipTypes() {
        return DescriptorHelper.getShortNames((String)"entityLink.preferenceGroup*", (ArchetypeService)this.service);
    }

    private PreferenceGroup getGroup(String name) {
        PreferenceGroup result = this.findGroup(name);
        if (result == null) {
            result = this.loadGroup(name);
        }
        if (result == null) {
            String[] relationshipTypes;
            boolean save = this.transactionManager != null;
            for (String relationshipType : relationshipTypes = this.getRelationshipTypes()) {
                Object[] shortNames = DescriptorHelper.getNodeShortNames((String)relationshipType, (String)TARGET, (ArchetypeService)this.service);
                if (!ArrayUtils.contains((Object[])shortNames, (Object)name)) continue;
                result = this.addGroup(name, relationshipType, save);
                break;
            }
            if (result == null) {
                throw new IllegalArgumentException("Argument 'name' is not a valid preference group name");
            }
        }
        return result;
    }

    private PreferenceGroup findGroup(String name) {
        PreferenceGroup result = null;
        for (PreferenceGroup group : this.groups) {
            if (!group.getEntity().isA(name)) continue;
            result = group;
            break;
        }
        return result;
    }

    private PreferenceGroup loadGroup(String name) {
        PreferenceGroup result = null;
        for (EntityLink link : this.bean.getValues(GROUPS, EntityLink.class)) {
            Entity entity;
            Reference target = link.getTarget();
            if (target == null || !target.isA(name) || (entity = (Entity)this.service.get(target, Entity.class)) == null) continue;
            result = new PreferenceGroup(entity, this.service);
            this.groups.add(result);
            break;
        }
        return result;
    }

    private PreferenceGroup addGroup(String name, String relationshipType, boolean save) {
        Entity entity = (Entity)this.service.create(name, Entity.class);
        this.bean.addTarget(GROUPS, relationshipType, (IMObject)entity);
        if (save) {
            try {
                this.bean.save(new IMObject[]{entity});
            }
            catch (Exception exception) {
                log.error("Failed to add group=" + name + " to preference=" + this.bean.getReference(), (Throwable)exception);
                this.reload();
                this.addGroup(name, relationshipType, false);
            }
        }
        PreferenceGroup result = new PreferenceGroup(entity, this.service);
        this.groups.add(result);
        return result;
    }

    private void setPreference(String groupName, String name, Object value, boolean save) {
        final PreferenceGroup group = this.getGroup(groupName);
        Object current = group.get(name);
        if (!Objects.equals(current, value)) {
            group.set(name, value);
            if (save) {
                TransactionTemplate template = new TransactionTemplate(this.transactionManager);
                template.setPropagationBehavior(3);
                try {
                    template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                        protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                            group.save();
                        }
                    });
                }
                catch (Exception exception) {
                    log.debug("Failed to save preference=" + group.getEntity().getObjectReference() + ", name=" + name + ", value=" + value, (Throwable)exception);
                    this.reload();
                    this.setPreference(groupName, name, value, false);
                }
            }
        }
    }

    private void reload() {
        Entity prefs = PreferenceManager.getPreferences(this.party, this.source, this.service, this.transactionManager);
        this.bean = this.service.getBean((IMObject)prefs);
        this.groups.clear();
    }
}

