/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.practice;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.openvpms.archetype.rules.doc.PrinterReference;
import org.openvpms.archetype.rules.practice.MailServer;
import org.openvpms.archetype.rules.util.EntityRelationshipHelper;
import org.openvpms.component.business.domain.im.common.SequencedPeriodRelationship;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.functor.SequenceComparator;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Policy;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class LocationRules {
    private final IArchetypeService service;
    private static final String SCHEDULE_VIEWS = "scheduleViews";
    private static final String WORK_LIST_VIEWS = "workListViews";

    public LocationRules(IArchetypeService service) {
        this.service = service;
    }

    public Party getPractice(Party location) {
        return (Party)this.service.getBean((IMObject)location).getSource("practice", Party.class);
    }

    public Party getDefaultDepositAccount(Party location) {
        return (Party)EntityRelationshipHelper.getDefaultTarget((Entity)location, "depositAccounts", false, (ArchetypeService)this.service);
    }

    public Entity getDefaultTill(Party location) {
        return EntityRelationshipHelper.getDefaultTarget((Entity)location, "tills", false, (ArchetypeService)this.service);
    }

    public List<Entity> getTills(Party location) {
        IMObjectBean bean = this.service.getBean((IMObject)location);
        return bean.getTargets("tills", Entity.class, Policies.active());
    }

    public Entity getDefaultTerminal(Entity till) {
        return EntityRelationshipHelper.getDefaultTarget(till, "terminals", false, (ArchetypeService)this.service);
    }

    public List<Entity> getTerminals(Entity till) {
        IMObjectBean bean = this.service.getBean((IMObject)till);
        return bean.getTargets("terminals", Entity.class, Policies.active());
    }

    public Entity getDefaultScheduleView(Party location) {
        return EntityRelationshipHelper.getDefaultTarget((Entity)location, SCHEDULE_VIEWS, false, (ArchetypeService)this.service);
    }

    public List<Entity> getScheduleViews(Party location) {
        IMObjectBean bean = this.service.getBean((IMObject)location);
        return bean.getTargets(SCHEDULE_VIEWS, Entity.class, Policies.active());
    }

    public boolean hasScheduleView(Party location, Reference view) {
        return this.service.getBean((IMObject)location).getTargetRefs(SCHEDULE_VIEWS).contains(view);
    }

    public Entity getDefaultWorkListView(Party location) {
        return EntityRelationshipHelper.getDefaultTarget((Entity)location, WORK_LIST_VIEWS, false, (ArchetypeService)this.service);
    }

    public List<Entity> getWorkListViews(Party location) {
        return this.service.getBean((IMObject)location).getTargets(WORK_LIST_VIEWS, Entity.class, Policies.active());
    }

    public boolean hasWorkListView(Party location, Reference view) {
        return this.service.getBean((IMObject)location).getTargetRefs(WORK_LIST_VIEWS).contains(view);
    }

    public Reference getDefaultStockLocationRef(Party location) {
        return EntityRelationshipHelper.getDefaultTargetRef((Entity)location, "stockLocations", true, (ArchetypeService)this.service);
    }

    public Party getDefaultStockLocation(Party location) {
        return (Party)EntityRelationshipHelper.getDefaultTarget((Entity)location, "stockLocations", true, (ArchetypeService)this.service);
    }

    public Lookup getPricingGroup(Party location) {
        IMObjectBean bean = this.service.getBean((IMObject)location);
        List values = bean.getValues("pricingGroup", Lookup.class);
        return !values.isEmpty() ? (Lookup)values.get(0) : null;
    }

    public Entity getAppointmentSMSTemplate(Party location) {
        return (Entity)this.service.getBean((IMObject)location).getTarget("smsAppointment", Entity.class);
    }

    public MailServer getMailServer(Party location) {
        Entity entity = (Entity)this.service.getBean((IMObject)location).getTarget("mailServer", Entity.class, Policies.active());
        return entity != null ? new MailServer(entity, (ArchetypeService)this.service) : null;
    }

    public List<Entity> getFollowupWorkLists(Party location) {
        Policy policy = Policies.active(SequencedPeriodRelationship.class, (Comparator)SequenceComparator.INSTANCE);
        return this.service.getBean((IMObject)location).getTargets("followupWorkLists", Entity.class, policy);
    }

    public PrinterReference getDefaultPrinter(Party location) {
        IMObjectBean bean = this.service.getBean((IMObject)location);
        return PrinterReference.fromString(bean.getString("defaultPrinter"));
    }

    public List<PrinterReference> getPrinters(Party location) {
        ArrayList<PrinterReference> result = new ArrayList<PrinterReference>();
        IMObjectBean bean = this.service.getBean((IMObject)location);
        for (IMObject printer : bean.getTargets("printers", Policies.active())) {
            PrinterReference reference = PrinterReference.fromString(this.service.getBean(printer).getString("printer"));
            if (reference == null) continue;
            result.add(reference);
        }
        return result;
    }

    public Entity getGapBenefitTill(Party location) {
        return (Entity)this.service.getBean((IMObject)location).getTarget("gapBenefitTill", Entity.class);
    }
}

