/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient.reminder;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.practice.Location;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.ArchetypeSortConstraint;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.JoinConstraint;
import org.openvpms.component.system.common.query.ObjectSelectConstraint;
import org.openvpms.component.system.common.query.ShortNameConstraint;

public class ReminderItemQueryFactory {
    private String[] archetypes;
    private Date from;
    private Date to;
    private String[] statuses;
    private Reference customerRef;
    private Location location = Location.ALL;
    private static final String START_TIME = "startTime";
    private static final String ID = "id";
    private static final String STATUS = "status";
    private static final String ENTITY = "entity";
    private static final String PRACTICE = "practice";
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private static final String NAME = "name";
    private static final String ACTIVE_END_TIME = "activeEndTime";
    private static final String REMINDER = "reminder";

    public ReminderItemQueryFactory() {
        this("act.patientReminderItem*");
    }

    public ReminderItemQueryFactory(String archetype) {
        this.setArchetype(archetype);
    }

    public ReminderItemQueryFactory(String archetype, String status) {
        this.setArchetype(archetype);
        this.setStatus(status);
    }

    public ReminderItemQueryFactory(String archetype, String[] statuses, Date from, Date to) {
        this(new String[]{archetype}, statuses, from, to);
    }

    public ReminderItemQueryFactory(String[] archetypes, String[] statuses, Date from, Date to) {
        this.setArchetypes(archetypes);
        this.setStatuses(statuses);
        this.setFrom(from);
        this.setTo(to);
    }

    public void setArchetype(String archetype) {
        this.setArchetypes(new String[]{archetype});
    }

    public void setArchetypes(String[] archetypes) {
        if (!TypeHelper.matches((String[])archetypes, (String)"act.patientReminderItem*")) {
            throw new IllegalArgumentException("Invalid reminder item names: " + StringUtils.join((Object[])archetypes, (char)','));
        }
        this.archetypes = archetypes;
    }

    public String[] getArchetypes() {
        return this.archetypes;
    }

    public Date getFrom() {
        return this.from;
    }

    public void setFrom(Date from) {
        this.from = from;
    }

    public Date getTo() {
        return this.to;
    }

    public void setTo(Date to) {
        this.to = to;
    }

    public void setStatus(String status) {
        String[] stringArray;
        if (status != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = status;
        } else {
            stringArray = null;
        }
        this.setStatuses(stringArray);
    }

    public void setStatuses(String[] statuses) {
        this.statuses = statuses;
    }

    public String[] getStatuses() {
        return this.statuses;
    }

    public void setCustomer(Party customer) {
        this.customerRef = customer != null ? customer.getObjectReference() : null;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public ArchetypeQuery createQuery() {
        String itemAlias = "item";
        String reminderAlias = REMINDER;
        String patientAlias = "patient";
        String customerAlias = "customer";
        ArchetypeQuery query = new ArchetypeQuery((BaseArchetypeConstraint)Constraints.shortName((String)"item", (String[])this.archetypes, (boolean)false));
        query.add((IConstraint)new ObjectSelectConstraint("item"));
        query.add((IConstraint)new ObjectSelectConstraint(REMINDER));
        query.add((IConstraint)new ObjectSelectConstraint("patient"));
        query.add((IConstraint)new ObjectSelectConstraint("customer"));
        if (this.from != null) {
            query.add((IConstraint)Constraints.gte((String)START_TIME, (Object)this.from));
        }
        if (this.to != null) {
            query.add((IConstraint)Constraints.lt((String)START_TIME, (Object)this.to));
        }
        if (this.statuses != null && this.statuses.length != 0) {
            query.add((IConstraint)Constraints.in((String)STATUS, (Object[])this.statuses));
        }
        JoinConstraint reminder = Constraints.join((String)SOURCE, (String)REMINDER);
        JoinConstraint patient = Constraints.join((String)ENTITY, (String)"patient");
        reminder.add((IConstraint)Constraints.eq((String)STATUS, (Object)"IN_PROGRESS")).add((IConstraint)Constraints.join((String)"patient", (String)"p").add((IConstraint)patient));
        ShortNameConstraint owner = Constraints.shortName((String)"owner", (String)"entityRelationship.patientOwner");
        ShortNameConstraint customer = Constraints.shortName((String)"customer", (String)"party.customerperson", (boolean)true);
        owner.add((IConstraint)Constraints.isNull((String)ACTIVE_END_TIME));
        query.add((IConstraint)Constraints.join((String)REMINDER, (String)"r").add((IConstraint)reminder));
        query.add((IConstraint)owner);
        query.add((IConstraint)customer);
        if (this.customerRef != null) {
            customer.add((IConstraint)Constraints.eq((String)ID, (Object)this.customerRef.getId()));
        }
        if (this.location.getPracticeLocation() != null) {
            customer.add((IConstraint)Constraints.join((String)PRACTICE, (String)"l2").add((IConstraint)Constraints.eq((String)TARGET, (Object)this.location.getPracticeLocation())));
        } else if (this.location.isNone()) {
            query.add((IConstraint)Constraints.notExists((ArchetypeQuery)Constraints.subQuery((String)"party.customerperson", (String)"c2").add((IConstraint)Constraints.join((String)PRACTICE, (String)"l2").add((IConstraint)Constraints.idEq((String)"customer", (String)"c2")))));
        }
        query.add((IConstraint)Constraints.idEq((String)"patient", (String)"owner.target"));
        query.add((IConstraint)Constraints.idEq((String)"customer", (String)"owner.source"));
        query.add((IConstraint)Constraints.sort((String)"customer", (String)NAME));
        query.add((IConstraint)Constraints.sort((String)"customer", (String)ID));
        query.add((IConstraint)new ArchetypeSortConstraint(true));
        query.add((IConstraint)Constraints.sort((String)"patient", (String)NAME));
        query.add((IConstraint)Constraints.sort((String)"patient", (String)ID));
        query.add((IConstraint)Constraints.sort((String)"item", (String)START_TIME));
        query.add((IConstraint)Constraints.sort((String)"item", (String)ID));
        return query;
    }

    public ReminderItemQueryFactory copy(String archetype) {
        ReminderItemQueryFactory result = new ReminderItemQueryFactory(archetype, this.statuses, this.from, this.to);
        result.customerRef = this.customerRef;
        result.location = this.location;
        return result;
    }
}

