/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient.reminder;

import java.util.Date;
import org.joda.time.Period;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.patient.reminder.ReminderGroupingPolicy;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class ReminderConfiguration {
    private final ArchetypeService service;
    private final IMObjectBean bean;
    private Party location;
    private final Period emailPeriod;
    private final Period emailCancelPeriod;
    private final Period smsPeriod;
    private final Period smsCancelPeriod;
    private final Period printPeriod;
    private final Period printCancelPeriod;
    private final Period exportPeriod;
    private final Period exportCancelPeriod;
    private final Period listPeriod;
    private final Period listCancelPeriod;
    private final boolean emailAttachments;
    private DocumentTemplate customerTemplate;
    private DocumentTemplate patientTemplate;

    public ReminderConfiguration(IMObject config, ArchetypeService service) {
        this.service = service;
        this.bean = service.getBean(config);
        this.emailPeriod = this.getPeriod(this.bean, "email");
        this.emailCancelPeriod = this.getPeriod(this.bean, "emailCancel");
        this.smsPeriod = this.getPeriod(this.bean, "sms");
        this.smsCancelPeriod = this.getPeriod(this.bean, "smsCancel");
        this.printPeriod = this.getPeriod(this.bean, "print");
        this.printCancelPeriod = this.getPeriod(this.bean, "printCancel");
        this.exportPeriod = this.getPeriod(this.bean, "export");
        this.exportCancelPeriod = this.getPeriod(this.bean, "exportCancel");
        this.listPeriod = this.getPeriod(this.bean, "list");
        this.listCancelPeriod = this.getPeriod(this.bean, "listCancel");
        this.emailAttachments = this.bean.getBoolean("emailAttachments");
    }

    public Party getLocation() {
        if (this.location == null) {
            this.location = (Party)this.bean.getTarget("location", Party.class);
        }
        return this.location;
    }

    public Period getEmailPeriod() {
        return this.emailPeriod;
    }

    public Period getEmailCancelPeriod() {
        return this.emailCancelPeriod;
    }

    public Date getEmailSendDate(Date dueDate) {
        return DateRules.minus(dueDate, this.getEmailPeriod());
    }

    public Date getEmailCancelDate(Date sendDate) {
        return DateRules.plus(sendDate, this.getEmailCancelPeriod());
    }

    public Period getSMSPeriod() {
        return this.smsPeriod;
    }

    public Period getSMSCancelPeriod() {
        return this.smsCancelPeriod;
    }

    public Date getSMSSendDate(Date dueDate) {
        return DateRules.minus(dueDate, this.getSMSPeriod());
    }

    public Date getSMSCancelDate(Date sendDate) {
        return DateRules.plus(sendDate, this.getSMSCancelPeriod());
    }

    public Period getPrintPeriod() {
        return this.printPeriod;
    }

    public Period getPrintCancelPeriod() {
        return this.printCancelPeriod;
    }

    public Date getPrintSendDate(Date dueDate) {
        return DateRules.minus(dueDate, this.getPrintPeriod());
    }

    public Date getPrintCancelDate(Date sendDate) {
        return DateRules.plus(sendDate, this.getPrintCancelPeriod());
    }

    public Period getExportPeriod() {
        return this.exportPeriod;
    }

    public Period getExportCancelPeriod() {
        return this.exportCancelPeriod;
    }

    public Date getExportSendDate(Date dueDate) {
        return DateRules.minus(dueDate, this.getExportPeriod());
    }

    public Date getExportCancelDate(Date sendDate) {
        return DateRules.plus(sendDate, this.getExportCancelPeriod());
    }

    public Period getListPeriod() {
        return this.listPeriod;
    }

    public Period getListCancelPeriod() {
        return this.listCancelPeriod;
    }

    public Date getListSendDate(Date dueDate) {
        return DateRules.minus(dueDate, this.getListPeriod());
    }

    public Date getListCancelDate(Date sendDate) {
        return DateRules.plus(sendDate, this.getListCancelPeriod());
    }

    public Date getMaxLeadTime(Date date) {
        Date result = DateRules.plus(date, this.getEmailPeriod());
        result = DateRules.max(result, DateRules.plus(date, this.getSMSPeriod()));
        result = DateRules.max(result, DateRules.plus(date, this.getPrintPeriod()));
        result = DateRules.max(result, DateRules.plus(date, this.getExportPeriod()));
        result = DateRules.max(result, DateRules.plus(date, this.getListPeriod()));
        return result;
    }

    public Date getSendDate(Date dueDate, String archetype) {
        switch (archetype) {
            case "act.patientReminderItemEmail": {
                return this.getEmailSendDate(dueDate);
            }
            case "act.patientReminderItemSMS": {
                return this.getSMSSendDate(dueDate);
            }
            case "act.patientReminderItemPrint": {
                return this.getPrintSendDate(dueDate);
            }
            case "act.patientReminderItemExport": {
                return this.getExportSendDate(dueDate);
            }
            case "act.patientReminderItemList": {
                return this.getListSendDate(dueDate);
            }
        }
        return null;
    }

    public Date getCancelDate(Date sendDate, String archetype) {
        switch (archetype) {
            case "act.patientReminderItemEmail": {
                return this.getEmailCancelDate(sendDate);
            }
            case "act.patientReminderItemSMS": {
                return this.getSMSCancelDate(sendDate);
            }
            case "act.patientReminderItemPrint": {
                return this.getPrintCancelDate(sendDate);
            }
            case "act.patientReminderItemExport": {
                return this.getExportCancelDate(sendDate);
            }
            case "act.patientReminderItemList": {
                return this.getListCancelDate(sendDate);
            }
        }
        return null;
    }

    public boolean getEmailAttachments() {
        return this.emailAttachments;
    }

    public DocumentTemplate getCustomerGroupedReminderTemplate() {
        Entity template;
        if (this.customerTemplate == null && (template = (Entity)this.bean.getTarget("customerTemplate", Entity.class)) != null) {
            this.customerTemplate = new DocumentTemplate(template, this.service);
        }
        return this.customerTemplate;
    }

    public DocumentTemplate getPatientGroupedReminderTemplate() {
        Entity template;
        if (this.patientTemplate == null && (template = (Entity)this.bean.getTarget("patientTemplate", Entity.class)) != null) {
            this.patientTemplate = new DocumentTemplate(template, this.service);
        }
        return this.patientTemplate;
    }

    public ReminderGroupingPolicy getGroupByCustomerPolicy() {
        return this.getPolicy(this.getCustomerGroupedReminderTemplate());
    }

    public ReminderGroupingPolicy getGroupByPatientPolicy() {
        return this.getPolicy(this.getPatientGroupedReminderTemplate());
    }

    private ReminderGroupingPolicy getPolicy(DocumentTemplate template) {
        ReminderGroupingPolicy policy;
        if (template == null) {
            policy = ReminderGroupingPolicy.NONE;
        } else {
            boolean email = template.getEmailTemplate() != null;
            boolean sms = template.getSMSTemplate() != null;
            policy = ReminderGroupingPolicy.getPolicy(true, email, sms);
        }
        return policy;
    }

    private Period getPeriod(IMObjectBean bean, String prefix) {
        DateUnits units = DateUnits.fromString(bean.getString(prefix + "Units"), DateUnits.DAYS);
        return units.toPeriod(bean.getInt(prefix + "Interval"));
    }
}

