/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient.reminder;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.party.PartyRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderEvent;
import org.openvpms.archetype.rules.patient.reminder.ReminderExporter;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;

public class ReminderCSVExporter
implements ReminderExporter {
    protected static final String[] HEADER = new String[]{"Customer Identifier", "Customer Title", "Customer First Name", "Customer Initials", "Customer Surname", "Company Name", "Customer Street Address", "Customer Suburb", "Customer State", "Customer Postcode", "Customer Phone", "Customer SMS", "Customer Email", "Patient Identifier", "Patient Name", "Patient Species", "Patient Breed", "Patient Sex", "Patient Colour", "Patient Date of Birth", "Reminder Type Identifier", "Reminder Type Name", "Reminder Due Date", "Reminder Count", "Reminder Last Sent Date", "Patient Weight", "Patient Weight Units", "Patient Weight Date", "Practice Location", "Next Appointment"};
    private final PracticeService practiceService;
    private final PartyRules partyRules;
    private final PatientRules patientRules;
    private final AppointmentRules appointmentRules;
    private final IArchetypeService service;
    private final DocumentHandlers handlers;
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    private static final String MIME_TYPE = "text/csv";

    public ReminderCSVExporter(PracticeService practiceService, PartyRules partyRules, PatientRules patientRules, AppointmentRules appointmentRules, IArchetypeService service, DocumentHandlers handlers) {
        this.practiceService = practiceService;
        this.partyRules = partyRules;
        this.patientRules = patientRules;
        this.appointmentRules = appointmentRules;
        this.service = service;
        this.handlers = handlers;
    }

    @Override
    public Document export(List<ReminderEvent> reminders, java.util.Date date) {
        char separator = this.getSeparator();
        StringWriter writer = new StringWriter();
        CSVWriter csv = new CSVWriter((Writer)writer, separator);
        this.writeHeader(csv);
        for (ReminderEvent event : reminders) {
            if (event.getReminderType() == null || event.getCustomer() == null || !TypeHelper.isA((IMObject)event.getContact(), (String)"contact.location") || event.getPatient() == null) continue;
            Act appointment = this.appointmentRules.getNextPatientAppointment(event.getPatient(), date);
            this.export(event, appointment, csv);
        }
        String name = "reminders-" + new Date(System.currentTimeMillis()) + ".csv";
        DocumentHandler handler = this.handlers.get(name, MIME_TYPE);
        byte[] buffer = writer.getBuffer().toString().getBytes(StandardCharsets.UTF_8);
        return handler.create(name, new ByteArrayInputStream(buffer), MIME_TYPE, buffer.length);
    }

    public char getSeparator() {
        return this.practiceService.getExportFileFieldSeparator();
    }

    protected void writeHeader(CSVWriter writer) {
        writer.writeNext(HEADER);
    }

    protected void export(ReminderEvent event, Act appointment, CSVWriter writer) {
        IMObjectBean customer = this.service.getBean((IMObject)event.getCustomer());
        IMObjectBean location = this.service.getBean((IMObject)event.getContact());
        IMObjectBean patient = this.service.getBean((IMObject)event.getPatient());
        IMObjectBean reminder = this.service.getBean((IMObject)event.getReminder());
        Entity reminderType = event.getReminderType();
        String[] line = this.getExportData(event, customer, location, patient, reminder, reminderType, appointment);
        writer.writeNext(line);
    }

    protected String[] getExportData(ReminderEvent event, IMObjectBean customer, IMObjectBean location, IMObjectBean patient, IMObjectBean reminder, Entity reminderType, Act appointment) {
        Party practiceLocation = (Party)customer.getTarget("practice", Party.class);
        String customerId = Long.toString(customer.getObject().getId());
        String title = this.getLookup(customer, "title");
        String firstName = customer.getString("firstName");
        String initials = customer.getString("initials");
        String lastName = customer.getString("lastName");
        String companyName = customer.getString("companyName");
        String address = location.getString("address");
        String suburb = this.getLookup(location, "suburb");
        String state = this.getLookup(location, "state");
        String postCode = location.getString("postcode");
        String phone = this.partyRules.getTelephone(event.getCustomer());
        String sms = this.partyRules.getSMSTelephone(event.getCustomer());
        String email = this.partyRules.getEmailAddress(event.getCustomer());
        String patientId = Long.toString(event.getPatient().getId());
        String patientName = patient.getString("name");
        String species = this.getLookup(patient, "species");
        String breed = this.getLookup(patient, "breed");
        String sex = this.getLookup(patient, "sex");
        String colour = patient.getString("colour");
        String dateOfBirth = this.getDate(patient.getDate("dateOfBirth"));
        String reminderTypeId = Long.toString(reminderType.getId());
        String reminderTypeName = reminderType.getName();
        String dueDate = this.getDate(event.getReminder().getActivityEndTime());
        String reminderCount = reminder.getString("reminderCount");
        String lastSentDate = this.getDate(reminder.getDate("lastSent"));
        Act lastWeight = this.patientRules.getWeightAct(event.getPatient());
        String weight = null;
        String weightUnits = null;
        String weightDate = null;
        if (lastWeight != null) {
            IMObjectBean bean = this.service.getBean((IMObject)lastWeight);
            weight = bean.getString("weight");
            weightUnits = bean.getString("units");
            weightDate = this.getDate(lastWeight.getActivityStartTime());
        }
        String locationName = practiceLocation != null ? practiceLocation.getName() : null;
        String nextAppointment = appointment != null ? ReminderCSVExporter.getDateTime(appointment.getActivityStartTime()) : null;
        return new String[]{customerId, title, firstName, initials, lastName, companyName, address, suburb, state, postCode, phone, sms, email, patientId, patientName, species, breed, sex, colour, dateOfBirth, reminderTypeId, reminderTypeName, dueDate, reminderCount, lastSentDate, weight, weightUnits, weightDate, locationName, nextAppointment};
    }

    protected IArchetypeService getService() {
        return this.service;
    }

    protected Party getPractice() {
        return this.practiceService.getPractice();
    }

    static String getDateTime(java.util.Date date) {
        return date != null ? formatter.format(DateRules.toLocalDateTime(date)) : null;
    }

    private String getDate(java.util.Date date) {
        return date != null ? new Date(date.getTime()).toString() : null;
    }

    private String getLookup(IMObjectBean bean, String node) {
        Lookup lookup = bean.getLookup(node);
        return lookup != null ? lookup.getName() : null;
    }
}

