/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.party;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.contact.AddressFormatter;
import org.openvpms.archetype.rules.contact.BasicAddressFormatter;
import org.openvpms.archetype.rules.party.ContactMatcher;
import org.openvpms.archetype.rules.party.Contacts;
import org.openvpms.archetype.rules.party.PurposeMatcher;
import org.openvpms.archetype.rules.party.SMSMatcher;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.archetype.NodeDescriptor;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.IMObjectBeanFactory;
import org.openvpms.component.model.entity.EntityIdentity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;

public class PartyRules {
    private final IArchetypeService service;
    private final LookupService lookups;
    private final AddressFormatter addressFormatter;

    public PartyRules(IArchetypeService service, LookupService lookups) {
        this(service, lookups, new BasicAddressFormatter((ArchetypeService)service, lookups));
    }

    public PartyRules(IArchetypeService service, LookupService lookups, AddressFormatter formatter) {
        this.service = service;
        this.lookups = lookups;
        this.addressFormatter = formatter;
    }

    @Deprecated
    public Object getCustomerNode(Party party, String nodeName) {
        if (party != null) {
            IMObjectBean bean = this.service.getBean((IMObject)party);
            NodeDescriptor descriptor = bean.getNode(nodeName);
            if (descriptor != null && descriptor.isLookup()) {
                return this.lookups.getName((IMObject)party, nodeName);
            }
            return bean.getValue(nodeName);
        }
        return null;
    }

    public String getFullName(Party party) {
        return this.getFullName(party, true);
    }

    public String getFullName(Party party, boolean includeTitle) {
        String name = null;
        if (party != null) {
            IMObjectBean bean = this.service.getBean((IMObject)party);
            name = bean.hasNode("companyName") && bean.getString("companyName") != null ? party.getName() : (bean.hasNode("title") && bean.hasNode("firstName") && bean.hasNode("lastName") ? this.getPersonName(bean, includeTitle) : StringUtils.trimToNull((String)party.getName()));
        }
        return name != null ? name : "";
    }

    public Set<Contact> getDefaultContacts() {
        HashSet<Contact> contacts = new HashSet<Contact>();
        Contact phone = (Contact)this.service.create("contact.phoneNumber", Contact.class);
        Contact location = (Contact)this.service.create("contact.location", Contact.class);
        this.service.deriveValues((IMObject)phone);
        this.service.deriveValues((IMObject)location);
        contacts.add(phone);
        contacts.add(location);
        return contacts;
    }

    public String getPreferredContacts(Party party) {
        StringBuilder result = new StringBuilder();
        for (Contact contact : Contacts.sort(party.getContacts())) {
            boolean preferred;
            IMObjectBean bean = this.service.getBean((IMObject)contact);
            if (!bean.hasNode("preferred") || !(preferred = bean.getBoolean("preferred")) || !bean.hasNode("description")) continue;
            String description = bean.getString("description");
            this.append(result, ", ", description);
        }
        return result.toString();
    }

    public String getContactPurposes(Contact contact) {
        List list;
        StringBuilder result = new StringBuilder();
        IMObjectBean bean = this.service.getBean((IMObject)contact);
        if (bean.hasNode("purposes") && !(list = bean.getValues("purposes", IMObject.class)).isEmpty()) {
            result.append("(");
            result.append(this.getValues(list, "name"));
            result.append(")");
        }
        return result.toString();
    }

    public String getBillingAddress(Party party, boolean singleLine) {
        return this.getAddress(party, "BILLING", singleLine);
    }

    public String getCorrespondenceAddress(Party party, boolean singleLine) {
        return this.getAddress(party, "CORRESPONDENCE", singleLine);
    }

    public String getCorrespondenceNameAddress(Party party, boolean singleLine) {
        return this.getFullName(party) + "\n" + this.getAddress(party, "CORRESPONDENCE", singleLine);
    }

    public Contact getAddressContact(Party party, String purpose) {
        return this.getContact(party, "contact.location", purpose);
    }

    public String getAddress(Party party, String purpose, boolean singleLine) {
        return this.formatAddress(this.getAddressContact(party, purpose), singleLine);
    }

    public Contact getTelephoneContact(Party party) {
        return this.getContact(party, "contact.phoneNumber", false, "FAX", new String[0]);
    }

    public Contact getTelephoneContact(Party party, String purpose) {
        return this.getTelephoneContact(party, false, purpose);
    }

    public Contact getTelephoneContact(Party party, boolean exact, String purpose) {
        return this.getContact(party, "contact.phoneNumber", exact, "FAX", purpose);
    }

    public String getTelephone(Party party) {
        return this.getTelephone(party, false);
    }

    public String getTelephone(Party party, boolean withName) {
        Contact contact = this.getTelephoneContact(party);
        return contact != null ? this.formatPhone(contact, withName) : "";
    }

    public String getHomeTelephone(Party party) {
        Contact contact = this.getTelephoneContact(party, "HOME");
        return contact != null ? this.formatPhone(contact, false) : "";
    }

    public String getMobileTelephone(Party party) {
        Contact contact = this.getTelephoneContact(party, true, "MOBILE");
        return contact != null ? this.formatPhone(contact, false) : "";
    }

    public String getWorkTelephone(Party party) {
        Contact contact = this.getTelephoneContact(party, true, "WORK");
        return contact != null ? this.formatPhone(contact, false) : "";
    }

    public String getSMSTelephone(Party party) {
        Contact contact = this.getSMSContact(party);
        return contact != null ? this.formatPhone(contact, false) : "";
    }

    public Contact getSMSContact(Party party) {
        return party != null ? this.getContact(party, new SMSMatcher((IMObjectBeanFactory)this.service)) : null;
    }

    public String getFaxNumber(Party party) {
        Contact contact = this.getContact(party, "contact.phoneNumber", true, null, "FAX");
        return contact != null ? this.formatPhone(contact, false) : "";
    }

    public String getEmailAddress(Party party) {
        Contact contact = this.getEmailContact(party);
        if (contact != null) {
            IMObjectBean bean = this.service.getBean((IMObject)contact);
            return bean.getString("emailAddress");
        }
        return "";
    }

    public Contact getEmailContact(Party party) {
        return this.getContact(party, "contact.email", null);
    }

    public String getWebsite(Party party) {
        Contact contact = this.getContact(party, "contact.website", null);
        if (contact != null) {
            IMObjectBean bean = this.service.getBean((IMObject)contact);
            return bean.getString("url");
        }
        return "";
    }

    public String getIdentities(Party party) {
        StringBuilder result = new StringBuilder();
        if (!party.getIdentities().isEmpty()) {
            ArrayList identities = new ArrayList(party.getIdentities());
            if (identities.size() > 1) {
                identities.sort((o1, o2) -> {
                    String value2;
                    String value1;
                    int compare = StringUtils.compare((String)o1.getArchetype(), (String)o2.getArchetype());
                    if (compare == 0 && (compare = StringUtils.compare((String)(value1 = o1.getName() != null ? o1.getName() : o1.getIdentity()), (String)(value2 = o2.getName() != null ? o2.getName() : o2.getIdentity()))) == 0) {
                        compare = Long.compare(o1.getId(), o2.getId());
                    }
                    return compare;
                });
            }
            for (EntityIdentity identity : identities) {
                String value = identity.getName() != null ? identity.getName() : identity.getIdentity();
                if (value == null) continue;
                IMObjectBean bean = this.service.getBean((IMObject)identity);
                String displayName = bean.getDisplayName();
                this.append(result, ", ", displayName).append(": ").append(value);
            }
        }
        return result.toString();
    }

    public Contact getContact(Party party, String type, String purpose) {
        Contact result = null;
        if (party != null) {
            result = purpose != null ? this.getContact(party, type, false, null, purpose) : this.getContact(party, type, false, null, new String[0]);
        }
        return result;
    }

    public Party getPractice() {
        return PracticeRules.getPractice((ArchetypeService)this.service);
    }

    public String getPracticeAddress(boolean singleLine) {
        return this.formatAddress(this.getContact(this.getPractice(), "contact.location", null), singleLine);
    }

    public String getPracticeTelephone() {
        return this.getWorkTelephone(this.getPractice());
    }

    public String getPracticeFaxNumber() {
        return this.getFaxNumber(this.getPractice());
    }

    public String getBpayId(Party party) {
        int sum = 0;
        String uid = String.valueOf(party.getId());
        for (int i = 0; i < uid.length(); ++i) {
            char ch = uid.charAt(uid.length() - i - 1);
            int digit = ch - 48;
            int weight = i % 2 == 0 ? 2 * digit - digit / 5 * 9 : digit;
            sum += weight;
        }
        sum = (10 - (Math.abs(sum) + 10) % 10) % 10;
        return uid + sum;
    }

    public Contact getContact(Party party, String type, boolean exact, String exclusion, String ... purposes) {
        Contact contact = null;
        if (party != null) {
            PurposeMatcher matcher = new PurposeMatcher(type, exact, (IMObjectBeanFactory)this.service, purposes);
            matcher.setExclusion(exclusion);
            contact = this.getContact(party, matcher);
        }
        return contact;
    }

    public List<Contact> getContacts(Party party, String type, boolean exact, String exclusion, String ... purposes) {
        ArrayList<Contact> result = new ArrayList<Contact>();
        if (party != null) {
            PurposeMatcher matcher = new PurposeMatcher(type, exact, (IMObjectBeanFactory)this.service, purposes);
            matcher.setExclusion(exclusion);
            for (Contact contact : party.getContacts()) {
                if (!matcher.matches(contact)) continue;
                result.add(contact);
            }
            Contacts.sort(result);
        }
        return result;
    }

    public String formatAddress(Contact contact, boolean singleLine) {
        String result = null;
        if (contact != null) {
            result = this.addressFormatter.format(contact, singleLine);
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public String formatPhone(Contact contact, boolean withName) {
        String name;
        IMObjectBean bean = this.service.getBean((IMObject)contact);
        String areaCode = StringUtils.trimToEmpty((String)bean.getString("areaCode"));
        String phone = StringUtils.trimToEmpty((String)bean.getString("telephoneNumber"));
        if (withName && !StringUtils.isEmpty((CharSequence)(name = contact.getName())) && bean.hasNode("name") && !bean.isDefaultValue("name")) {
            phone = phone + " (" + name + ")";
        }
        if (StringUtils.isEmpty((CharSequence)areaCode)) {
            return phone;
        }
        return "(" + areaCode + ") " + phone;
    }

    public Lookup getDefaultCountry() {
        return this.lookups.getDefaultLookup("lookup.country");
    }

    protected IArchetypeService getArchetypeService() {
        return this.service;
    }

    protected LookupService getLookupService() {
        return this.lookups;
    }

    private String getPersonName(IMObjectBean bean, boolean includeTitle) {
        String title;
        StringBuilder result = new StringBuilder();
        String string = title = includeTitle ? this.lookups.getName(bean.getObject(), "title") : null;
        if (title != null) {
            result.append(title);
        }
        this.append(result, " ", bean.getString("firstName"));
        this.append(result, " ", bean.getString("lastName"));
        return result.toString();
    }

    private String getValues(List<IMObject> objects, String node) {
        StringBuilder result = new StringBuilder();
        ArrayList<String> values = new ArrayList<String>();
        for (IMObject object : objects) {
            IMObjectBean bean = this.service.getBean(object);
            if (!bean.hasNode(node)) continue;
            String value = bean.getString(node, "");
            values.add(value);
        }
        if (values.size() > 1) {
            Collections.sort(values);
        }
        for (String value : values) {
            if (result.length() != 0) {
                result.append(", ");
            }
            result.append(value);
        }
        return result.toString();
    }

    private Contact getContact(Party party, ContactMatcher matcher) {
        return Contacts.find(Contacts.sort(party.getContacts()), matcher);
    }

    private StringBuilder append(StringBuilder builder, String separator, String value) {
        if (!StringUtils.isEmpty((CharSequence)value)) {
            if (builder.length() != 0) {
                builder.append(separator);
            }
            builder.append(value);
        }
        return builder;
    }
}

