/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.statement;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.openvpms.archetype.component.processor.AbstractProcessor;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.statement.Statement;
import org.openvpms.archetype.rules.finance.statement.StatementActHelper;
import org.openvpms.archetype.rules.finance.statement.StatementPeriod;
import org.openvpms.archetype.rules.finance.statement.StatementProcessorException;
import org.openvpms.archetype.rules.finance.statement.StatementRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;

public class StatementProcessor
extends AbstractProcessor<Party, Statement> {
    private final IArchetypeService service;
    private final Date statementDate;
    private final StatementRules rules;
    private final StatementActHelper actHelper;
    private boolean reprint;

    public StatementProcessor(Date statementDate, Party practice, IArchetypeService service, CustomerAccountRules accountRules) {
        this.service = service;
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        if (calendar.getTime().compareTo(statementDate) < 0) {
            throw new StatementProcessorException(StatementProcessorException.ErrorCode.InvalidStatementDate, statementDate);
        }
        this.rules = new StatementRules(practice, service, accountRules);
        this.actHelper = new StatementActHelper(service);
        this.statementDate = this.actHelper.getStatementTimestamp(statementDate);
    }

    public void setReprint(boolean reprint) {
        this.reprint = reprint;
    }

    @Override
    public void process(Party customer) {
        StatementPeriod period = new StatementPeriod(customer, this.statementDate, this.actHelper);
        if (!period.isPrinted() || this.reprint) {
            Date open = period.getOpeningBalanceTimestamp();
            Date close = period.getClosingBalanceTimestamp();
            Iterable<FinancialAct> acts = !period.hasStatement() ? this.rules.getStatementPreview(customer, open, this.statementDate, true, true) : this.rules.getStatement(customer, open, close);
            List<Contact> contacts = this.getContacts(customer);
            Statement statement = new Statement(customer, contacts, this.statementDate, open, close, acts, period.isPrinted());
            this.notifyListeners(statement);
        }
    }

    private List<Contact> getContacts(Party customer) {
        ArrayList<Contact> result = new ArrayList<Contact>();
        this.addBillingContacts(result, customer, "contact.email");
        this.addBillingContacts(result, customer, "contact.location");
        if (result.isEmpty()) {
            for (Contact contact : customer.getContacts()) {
                if (!contact.isA("contact.location")) continue;
                result.add(contact);
            }
        }
        return result;
    }

    private void addBillingContacts(List<Contact> list, Party customer, String shortName) {
        block0: for (Contact contact : customer.getContacts()) {
            if (!contact.isA(shortName)) continue;
            IMObjectBean bean = this.service.getBean((IMObject)contact);
            List purposes = bean.getValues("purposes", Lookup.class);
            for (Lookup purpose : purposes) {
                if (!"BILLING".equals(purpose.getCode())) continue;
                list.add(contact);
                continue block0;
            }
        }
    }
}

