/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.statement;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.openvpms.archetype.component.processor.Processor;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.statement.StatementActHelper;
import org.openvpms.archetype.rules.finance.statement.StatementPeriod;
import org.openvpms.archetype.rules.finance.statement.StatementProcessorException;
import org.openvpms.archetype.rules.finance.statement.StatementRules;
import org.openvpms.archetype.rules.laboratory.LaboratoryRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EndOfPeriodProcessor
implements Processor<Party> {
    private final Date timestamp;
    private final boolean postCompletedCharges;
    private final IArchetypeRuleService service;
    private final StatementActHelper acts;
    private final CustomerAccountRules account;
    private final LaboratoryRules laboratoryRules;
    private final StatementRules statement;
    private static final Logger log = LoggerFactory.getLogger(EndOfPeriodProcessor.class);

    public EndOfPeriodProcessor(Date statementDate, boolean postCompletedCharges, Party practice, IArchetypeRuleService service, CustomerAccountRules rules, LaboratoryRules laboratoryRules) {
        this.service = service;
        statementDate = DateRules.getDate(statementDate);
        if (statementDate.compareTo(DateRules.getYesterday()) > 0) {
            throw new StatementProcessorException(StatementProcessorException.ErrorCode.InvalidStatementDate, statementDate);
        }
        this.acts = new StatementActHelper((IArchetypeService)service);
        this.account = rules;
        this.statement = new StatementRules(practice, (IArchetypeService)service, rules);
        this.timestamp = this.acts.getStatementTimestamp(statementDate);
        this.postCompletedCharges = postCompletedCharges;
        this.laboratoryRules = laboratoryRules;
    }

    @Override
    public void process(Party customer) {
        StatementPeriod period = new StatementPeriod(customer, this.timestamp, this.acts);
        if (!period.hasStatement()) {
            boolean needStatement = false;
            Date open = period.getOpeningBalanceTimestamp();
            Date close = period.getClosingBalanceTimestamp();
            if (this.postCompletedCharges) {
                needStatement = this.postCompletedCharges(customer, period);
            }
            BigDecimal balance = null;
            if (!needStatement) {
                balance = this.account.getBalance(customer, open, close, period.getOpeningBalance());
                if (balance.compareTo(BigDecimal.ZERO) == 0) {
                    if (this.acts.hasAccountActivity(customer, open, close)) {
                        needStatement = true;
                    }
                } else {
                    needStatement = true;
                }
            }
            if (needStatement) {
                if (balance == null) {
                    balance = this.account.getBalance(customer, open, close, period.getOpeningBalance());
                }
                this.createPeriodEnd(customer, period, balance);
            }
        }
    }

    public void createPeriodEnd(Party customer, StatementPeriod period, BigDecimal balance) {
        BigDecimal accountFee;
        Date overdueDate;
        BigDecimal overdue = BigDecimal.ZERO;
        FinancialAct fee = null;
        if (balance.compareTo(BigDecimal.ZERO) != 0 && (overdue = this.account.getOverdueBalance(customer, this.timestamp, overdueDate = this.account.getOverdueDate(customer, this.timestamp))).compareTo(BigDecimal.ZERO) != 0 && (accountFee = this.statement.getAccountFee(customer, this.timestamp)).compareTo(BigDecimal.ZERO) != 0) {
            Date feeStartTime = period.getFeeTimestamp();
            fee = this.statement.createAccountingFeeAdjustment(customer, accountFee, feeStartTime);
            balance = balance.add(accountFee);
        }
        Date closeTime = period.getClosingBalanceTimestamp();
        Date openTime = new Date(closeTime.getTime() + 1000L);
        FinancialAct close = this.account.createClosingBalance(customer, closeTime, balance);
        FinancialAct open = this.account.createOpeningBalance(customer, openTime, balance);
        IMObjectBean bean = this.service.getBean((IMObject)close);
        bean.setValue("overdueBalance", (Object)overdue);
        if (fee != null) {
            this.service.save(Arrays.asList(fee, close, open));
        } else {
            this.service.save(Arrays.asList(close, open));
        }
    }

    private boolean postCompletedCharges(Party customer, StatementPeriod period) {
        boolean needStatement = false;
        for (Act act : this.acts.getCompletedCharges(customer, this.timestamp, period.getOpeningBalanceTimestamp(), period.getClosingBalanceTimestamp())) {
            if (!this.canPost(act)) continue;
            this.post(act, period);
            needStatement = true;
        }
        return needStatement;
    }

    private boolean canPost(Act act) {
        boolean result = true;
        if (act.isA("act.customerAccountChargesInvoice")) {
            IMObjectBean bean = this.service.getBean((IMObject)act);
            HashMap<Reference, Act> investigations = new HashMap<Reference, Act>();
            for (FinancialAct item : bean.getTargets("items", FinancialAct.class)) {
                if ("ORDERED".equals(item.getStatus())) {
                    log.warn("Cannot POST COMPLETED invoice={}: it has an outstanding order", (Object)act.getId());
                    result = false;
                    break;
                }
                if (!this.hasUnsubmittedInvestigations(item, investigations)) continue;
                log.warn("Cannot POST COMPLETED invoice={}: it has an unsubmitted investigation", (Object)act.getId());
                result = false;
                break;
            }
        }
        return result;
    }

    private boolean hasUnsubmittedInvestigations(FinancialAct item, Map<Reference, Act> investigations) {
        IMObjectBean itemBean = this.service.getBean((IMObject)item);
        for (Reference ref : itemBean.getTargetRefs("investigations")) {
            Act investigation = investigations.computeIfAbsent(ref, reference -> (Act)this.service.get(reference, Act.class));
            if (investigation == null || !this.laboratoryRules.isUnsubmittedInvestigation(investigation)) continue;
            return true;
        }
        return false;
    }

    private void post(Act act, StatementPeriod period) {
        act.setActivityStartTime(period.getCompletedChargeTimestamp());
        act.setStatus("POSTED");
        this.service.save((IMObject)act);
    }
}

