/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.invoice;

import org.openvpms.archetype.rules.finance.invoice.DemographicUpdateHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;

class InvoiceItemSaveRules {
    private final IMObjectBean itemBean;
    private final IArchetypeService service;
    private IMObjectBean productBean;

    public InvoiceItemSaveRules(Act act, IArchetypeService service) {
        this.service = service;
        if (!TypeHelper.isA((IMObject)act, (String)"act.customerAccountInvoiceItem")) {
            throw new IllegalArgumentException("Invalid argument 'act'");
        }
        this.itemBean = service.getBean((IMObject)act);
        Product product = (Product)this.itemBean.getTarget("product", Product.class);
        if (product != null) {
            this.productBean = service.getBean((IMObject)product);
        }
    }

    public void save() {
        if (this.productBean != null) {
            DemographicUpdateHelper helper = new DemographicUpdateHelper(this.itemBean, this.productBean, this.service);
            helper.processDemographicUpdates();
        }
    }
}

