/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.doc;

import org.openvpms.archetype.rules.act.ActCopyHandler;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

class VersioningCopyHandler
extends ActCopyHandler {
    private static final String VERSIONS = "versions";
    private static final String DOCUMENT = "document";

    public VersioningCopyHandler(Act template, ArchetypeService service) {
        this.setCopy(Participation.class);
        this.setExclude(ActIdentity.class);
        IMObjectBean bean = service.getBean((IMObject)template);
        if (bean.hasNode(VERSIONS)) {
            String[] shortNames;
            for (String shortName : shortNames = bean.getArchetypeRange(VERSIONS)) {
                String[] targetShortNames = DescriptorHelper.getNodeShortNames((String)shortName, (String)"target", (ArchetypeService)service);
                if (targetShortNames.length < 1) continue;
                String[][] map = new String[1][2];
                map[0][0] = template.getArchetype();
                map[0][1] = targetShortNames[0];
                this.setShortNameMap(map);
                break;
            }
        }
    }

    @Override
    public IMObject getObject(IMObject object, ArchetypeService service) {
        IMObject result = super.getObject(object, service);
        if (result instanceof DocumentAct && result != object && object instanceof DocumentAct) {
            Reference document = ((DocumentAct)object).getDocument();
            ((DocumentAct)result).setDocument(document);
        }
        return result;
    }

    @Override
    protected boolean checkCopyable(ArchetypeDescriptor archetype, NodeDescriptor node) {
        boolean result = true;
        if (DocumentAct.class.isAssignableFrom(archetype.getClazz())) {
            String name = node.getName();
            result = !DOCUMENT.equals(name);
        }
        return result;
    }
}

