/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.letterhead;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.openvpms.archetype.rules.doc.DocumentException;
import org.openvpms.archetype.rules.doc.LogoService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.jxpath.AbstractObjectFunctions;
import org.openvpms.component.system.common.jxpath.FunctionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LetterheadFunctions
extends AbstractObjectFunctions {
    private final LogoService logoService;
    private final ArchetypeService service;
    private static final Logger log = LoggerFactory.getLogger(LetterheadFunctions.class);

    public LetterheadFunctions(LogoService logoService, ArchetypeService service) {
        super("letterhead");
        this.setObject((Object)this);
        this.logoService = logoService;
        this.service = service;
    }

    public URL logo(Object object) {
        IMObjectBean bean;
        Entity letterhead;
        object = FunctionHelper.unwrap((Object)object);
        URL result = null;
        if (object instanceof Party && (letterhead = (Entity)(bean = this.service.getBean((IMObject)((Party)object))).getTarget("letterhead", Entity.class)) != null) {
            try {
                result = this.getLogo(letterhead);
            }
            catch (Exception exception) {
                log.warn("Failed to retrieve logo for letterhead {}: {}", new Object[]{letterhead.getName(), exception.getMessage(), exception});
            }
        }
        return result;
    }

    private URL getLogo(Entity letterhead) {
        URL result;
        IMObjectBean bean = this.service.getBean((IMObject)letterhead);
        String logoFile = bean.getString("logoFile");
        if (logoFile != null) {
            try {
                result = new File(logoFile).toURI().toURL();
            }
            catch (IOException exception) {
                throw new DocumentException(DocumentException.ErrorCode.NotFound, logoFile);
            }
        } else {
            result = this.logoService.getURL(letterhead);
        }
        return result;
    }
}

