/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.insurance;

import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.jxpath.FunctionHelper;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;

public class InsuranceFunctions {
    private final InsuranceRules insuranceRules;
    private final PatientRules patientRules;
    private final IArchetypeService service;

    public InsuranceFunctions(InsuranceRules insuranceRules, PatientRules patientRules, IArchetypeService service) {
        this.insuranceRules = insuranceRules;
        this.patientRules = patientRules;
        this.service = service;
    }

    public boolean claimed(FinancialAct claim, FinancialAct item) {
        boolean result = false;
        if (claim != null && item != null) {
            ArchetypeQuery query = new ArchetypeQuery(claim.getObjectReference()).add((IConstraint)Constraints.join((String)"items", (String)"c").add((IConstraint)Constraints.join((String)"target", (String)"ct").add((IConstraint)Constraints.join((String)"items", (String)"i").add((IConstraint)Constraints.eq((String)"target", (Object)item))))).add((IConstraint)new NodeSelectConstraint("id"));
            query.setMaxResults(1);
            result = new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query).hasNext();
        }
        return result;
    }

    public Act policy(Object object) {
        return this.policy(object, false);
    }

    public Act policy(Object object, boolean mostRecent) {
        Party owner;
        Act policy = null;
        Party patient = (Party)FunctionHelper.unwrap((Object)object, Party.class, (String)"party.patientpet");
        if (patient != null && (owner = this.patientRules.getOwner(patient)) != null) {
            policy = mostRecent ? this.insuranceRules.getPolicy(owner, patient) : this.insuranceRules.getCurrentPolicy(owner, patient);
        }
        return policy;
    }
}

