/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.date;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class RelativeDateParser {
    private final Pattern pattern = Pattern.compile("\\s*([+-]?\\d+)([hdmwyq])([se]?)\\s*");

    public Date parse(String source) {
        return this.parse(source, null);
    }

    public Date parse(String source, Date date) {
        if (StringUtils.isEmpty((CharSequence)source)) {
            return null;
        }
        if (date == null) {
            date = new Date();
        }
        Matcher matcher = this.pattern.matcher(source.toLowerCase());
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int start = 0;
        boolean neg = false;
        boolean first = true;
        while (start < source.length() && matcher.find(start)) {
            if (start != matcher.start()) {
                return null;
            }
            String valueGroup = matcher.group(1);
            int value = Integer.parseInt(valueGroup);
            if (first) {
                if (value < 0) {
                    neg = true;
                }
                first = false;
            } else if (value >= 0 && valueGroup.charAt(0) != '+' && neg) {
                value = -value;
            }
            String field = matcher.group(2);
            String se = matcher.group(3);
            switch (field) {
                case "d": {
                    ((Calendar)calendar).add(5, value);
                    break;
                }
                case "m": {
                    ((Calendar)calendar).add(2, value);
                    if (se.equals("s")) {
                        calendar.set(5, 1);
                        break;
                    }
                    if (!se.equals("e")) break;
                    calendar.set(5, 1);
                    ((Calendar)calendar).add(2, 1);
                    ((Calendar)calendar).add(5, -1);
                    break;
                }
                case "w": {
                    ((Calendar)calendar).add(3, value);
                    if (se.equals("s")) {
                        calendar.set(7, 2);
                        break;
                    }
                    if (!se.equals("e")) break;
                    calendar.set(7, 6);
                    break;
                }
                case "q": {
                    int k;
                    ((Calendar)calendar).add(2, 3 * value);
                    if (se.equals("s")) {
                        calendar.set(5, 1);
                        k = calendar.get(2);
                        k = k / 3 * 3;
                        calendar.set(2, k);
                        break;
                    }
                    if (!se.equals("e")) break;
                    calendar.set(5, 1);
                    k = calendar.get(2);
                    k = k / 3 * 3;
                    calendar.set(2, k);
                    ((Calendar)calendar).add(2, 3);
                    ((Calendar)calendar).add(5, -1);
                    break;
                }
                case "h": {
                    ((Calendar)calendar).add(11, value);
                    break;
                }
                default: {
                    ((Calendar)calendar).add(1, value);
                    if (se.equals("s")) {
                        calendar.set(5, 1);
                        calendar.set(2, 0);
                        break;
                    }
                    if (!se.equals("e")) break;
                    calendar.set(5, 1);
                    calendar.set(2, 0);
                    ((Calendar)calendar).add(1, 1);
                    ((Calendar)calendar).add(5, -1);
                }
            }
            start = matcher.end();
        }
        return start == source.length() ? calendar.getTime() : null;
    }
}

