/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.component.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openvpms.archetype.component.processor.AbstractProcessor;
import org.openvpms.archetype.component.processor.ActionProcessor;
import org.openvpms.archetype.component.processor.ProcessorListener;

public abstract class AbstractActionProcessor<Action, Type, Event>
extends AbstractProcessor<Type, Event>
implements ActionProcessor<Action, Type, Event> {
    private final Map<Action, List<ProcessorListener<Event>>> actionListeners = new HashMap<Action, List<ProcessorListener<Event>>>();

    protected AbstractActionProcessor() {
    }

    @Override
    public void addListener(Action action, ProcessorListener<Event> listener) {
        List list = this.actionListeners.computeIfAbsent(action, k -> new ArrayList());
        list.add(listener);
    }

    @Override
    public void removeListener(Action action, ProcessorListener<Event> listener) {
        List<ProcessorListener<Event>> list = this.actionListeners.get(action);
        if (list != null) {
            list.remove(listener);
        }
    }

    protected void notifyListeners(Action action, Event event) {
        this.notifyListeners(event);
        List<ProcessorListener<Event>> list = this.actionListeners.get(action);
        if (list != null) {
            this.notifyListeners((Action)list, event);
        }
    }
}

