/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.util;

import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang3.time.DateUtils;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.TestHelper;

public class DateRulesTestCase {
    @Test
    public void testGetToday() {
        Date expected = DateUtils.truncate((Date)new Date(), (int)5);
        Assert.assertEquals((Object)expected, (Object)DateRules.getToday());
    }

    @Test
    public void testGetTomorrow() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date());
        calendar.add(5, 1);
        Date expected = DateUtils.truncate((Date)calendar.getTime(), (int)5);
        Assert.assertEquals((Object)expected, (Object)DateRules.getTomorrow());
    }

    @Test
    public void testGetNextDate() {
        Date date = TestHelper.getDatetime("2012-01-05 12:34:32");
        Date expected = TestHelper.getDate("2012-01-06");
        Assert.assertEquals((Object)expected, (Object)DateRules.getNextDate((Date)date));
    }

    @Test
    public void testGetPreviousDate() {
        Date date = TestHelper.getDatetime("2012-01-05 12:34:32");
        Date expected = TestHelper.getDate("2012-01-04");
        Assert.assertEquals((Object)expected, (Object)DateRules.getPreviousDate((Date)date));
    }

    @Test
    public void testGetDaysInMonth() {
        Assert.assertEquals((long)31L, (long)DateRules.getDaysInMonth((Date)TestHelper.getDate("2015-12-01")));
        Assert.assertEquals((long)30L, (long)DateRules.getDaysInMonth((Date)TestHelper.getDate("2015-06-06")));
        Assert.assertEquals((long)28L, (long)DateRules.getDaysInMonth((Date)TestHelper.getDate("2015-02-05")));
        Assert.assertEquals((long)29L, (long)DateRules.getDaysInMonth((Date)TestHelper.getDate("2012-02-05")));
    }

    @Test
    public void testDateIsToDay() {
        Date now = new Date();
        Date yesterday = DateRules.getYesterday();
        Date tomorrow = DateRules.getTomorrow();
        Assert.assertTrue((boolean)DateRules.isToday((Date)now));
        Assert.assertFalse((boolean)DateRules.isToday((Date)yesterday));
        Assert.assertFalse((boolean)DateRules.isToday((Date)tomorrow));
    }

    @Test
    public void testOffsetDateTimeIsToday() {
        OffsetDateTime now = OffsetDateTime.now();
        OffsetDateTime yesterday = now.minusDays(1L);
        OffsetDateTime tomorrow = now.plusDays(1L);
        Assert.assertTrue((boolean)DateRules.isToday((OffsetDateTime)now));
        Assert.assertFalse((boolean)DateRules.isToday((OffsetDateTime)yesterday));
        Assert.assertFalse((boolean)DateRules.isToday((OffsetDateTime)tomorrow));
    }

    @Test
    public void testIsTodayDifferentTimeZone() {
        OffsetDateTime now = OffsetDateTime.now();
        if (now.getHour() < 23) {
            int offsetSeconds = now.getOffset().getTotalSeconds();
            ZoneOffset plus1 = ZoneOffset.ofTotalSeconds(offsetSeconds + 3600);
            ZoneOffset minus1 = ZoneOffset.ofTotalSeconds(offsetSeconds - 3600);
            OffsetDateTime nowPlus1Zone = now.withOffsetSameInstant(plus1);
            Assert.assertFalse((boolean)DateRules.isToday((OffsetDateTime)nowPlus1Zone.withHour(0).truncatedTo(ChronoUnit.HOURS)));
            Assert.assertTrue((boolean)DateRules.isToday((OffsetDateTime)nowPlus1Zone.withHour(23).withMinute(59)));
            OffsetDateTime nowMinus1Zone = now.withOffsetSameInstant(minus1);
            Assert.assertTrue((boolean)DateRules.isToday((OffsetDateTime)nowMinus1Zone.withHour(0).truncatedTo(ChronoUnit.HOURS)));
            Assert.assertFalse((boolean)DateRules.isToday((OffsetDateTime)nowMinus1Zone.withHour(23).withMinute(59)));
        }
    }

    @Test
    public void testIsTomorrow() {
        OffsetDateTime now = OffsetDateTime.now();
        OffsetDateTime yesterday = now.minusDays(1L);
        OffsetDateTime tomorrow = now.plusDays(1L);
        Assert.assertTrue((boolean)DateRules.isTomorrow((OffsetDateTime)tomorrow));
        Assert.assertFalse((boolean)DateRules.isTomorrow((OffsetDateTime)now));
        Assert.assertFalse((boolean)DateRules.isTomorrow((OffsetDateTime)yesterday));
    }

    @Test
    public void testIsTomorrowDifferentTimeZone() {
        OffsetDateTime now = OffsetDateTime.now();
        if (now.getHour() < 23) {
            OffsetDateTime tomorrow = now.plusDays(1L);
            int offsetSeconds = tomorrow.getOffset().getTotalSeconds();
            ZoneOffset plus1 = ZoneOffset.ofTotalSeconds(offsetSeconds + 3600);
            ZoneOffset minus1 = ZoneOffset.ofTotalSeconds(offsetSeconds - 3600);
            OffsetDateTime tomPlus1Zone = tomorrow.withOffsetSameInstant(plus1);
            Assert.assertFalse((boolean)DateRules.isTomorrow((OffsetDateTime)tomPlus1Zone.withHour(0).truncatedTo(ChronoUnit.HOURS)));
            Assert.assertTrue((boolean)DateRules.isTomorrow((OffsetDateTime)tomPlus1Zone.withHour(23).withMinute(59)));
            OffsetDateTime tomMinus1Zone = tomorrow.withOffsetSameInstant(minus1);
            Assert.assertTrue((boolean)DateRules.isTomorrow((OffsetDateTime)tomMinus1Zone.withHour(0).truncatedTo(ChronoUnit.HOURS)));
            Assert.assertFalse((boolean)DateRules.isTomorrow((OffsetDateTime)tomMinus1Zone.withHour(23).withMinute(59)));
        }
    }
}

