/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.tools.account;

import java.math.BigDecimal;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.AbstractCustomerAccountTest;
import org.openvpms.archetype.rules.finance.account.CustomerBalanceUpdater;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.tools.account.AccountBalanceTool;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

public class AccountBalanceToolTestCase
extends AbstractCustomerAccountTest {
    private AccountBalanceTool tool;
    @Autowired
    private CustomerBalanceUpdater updater;
    @Autowired
    private PlatformTransactionManager transactionManager;
    private IArchetypeService service;

    @Before
    public void setUp() {
        this.service = (IArchetypeService)this.applicationContext.getBean("archetypeService", IArchetypeService.class);
        this.tool = new AccountBalanceTool(this.service, this.updater, this.transactionManager);
    }

    @Test
    public void testGenerateForCustomerId() {
        Party customer = this.getCustomer();
        long id = customer.getId();
        BigDecimal amount = MathRules.ONE_HUNDRED;
        FinancialAct debit = this.createInitialBalance(amount);
        this.service.save((IMObject)debit);
        this.checkEquals(BigDecimal.ZERO, this.accountRules.getBalance(customer));
        Assert.assertFalse((boolean)this.tool.check(id));
        this.tool.generate(id);
        this.checkEquals(amount, this.accountRules.getBalance(customer));
        FinancialAct credit = this.createBadDebt(amount);
        this.service.save((IMObject)credit);
        this.tool.generate(id);
        this.checkEquals(BigDecimal.ZERO, this.accountRules.getBalance(customer));
        Assert.assertTrue((boolean)this.tool.check(id));
    }

    @Test
    public void testGenerateForInvoice() {
        BigDecimal amount = new BigDecimal(100);
        this.checkGenerate(this.createChargesInvoice(amount), amount);
    }

    @Test
    public void testGenerateForNegativeInvoice() {
        BigDecimal amount = new BigDecimal(-100);
        this.checkGenerate(this.createChargesInvoice(amount), amount);
    }

    @Test
    public void testGenerateForCredit() {
        BigDecimal amount = new BigDecimal(50);
        this.checkGenerate(this.createChargesCredit(amount), amount.negate());
    }

    @Test
    public void testGenerateForNegativeCredit() {
        BigDecimal amount = new BigDecimal(50);
        this.checkGenerate(this.createChargesCredit(amount.negate()), amount);
    }

    @Test
    public void testGenerateForCustomerName() {
        Party customer = this.getCustomer();
        String name = customer.getName();
        BigDecimal amount = MathRules.ONE_HUNDRED;
        FinancialAct debit = this.createInitialBalance(amount);
        this.service.save((IMObject)debit);
        this.checkEquals(BigDecimal.ZERO, this.accountRules.getBalance(customer));
        Assert.assertFalse((boolean)this.tool.check(name));
        this.tool.generate(name);
        this.checkEquals(amount, this.accountRules.getBalance(customer));
        FinancialAct credit = this.createBadDebt(amount);
        this.service.save((IMObject)credit);
        this.tool.generate(name);
        this.checkEquals(BigDecimal.ZERO, this.accountRules.getBalance(customer));
        Assert.assertTrue((boolean)this.tool.check(name));
    }

    private void checkGenerate(List<FinancialAct> charge, BigDecimal balance) {
        Party customer = this.getCustomer();
        this.service.save(charge);
        this.checkEquals(BigDecimal.ZERO, this.accountRules.getBalance(customer));
        Assert.assertFalse((boolean)this.tool.check(customer.getId()));
        this.tool.generate(customer.getId());
        this.checkEquals(balance, this.accountRules.getBalance(customer));
    }
}

