/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.user;

import java.util.Set;
import org.apache.commons.lang3.RandomUtils;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.archetype.test.builder.doc.TestDocumentBuilder;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.lookup.TestLookupBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.party.AbstractTestPartyBuilder;
import org.openvpms.component.business.domain.im.security.SecurityRole;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestUserBuilder
extends AbstractTestPartyBuilder<User, TestUserBuilder> {
    private final UserRules userRules;
    private final TestDocumentFactory documentFactory;
    private ValueStrategy username = ValueStrategy.random("zuser");
    private ValueStrategy password = ValueStrategy.random("zpassword");
    private ValueStrategy changePassword = ValueStrategy.unset();
    private String titleCode;
    private String firstName;
    private String lastName;
    private String qualifications;
    private boolean clinician;
    private boolean administrator;
    private ValueStrategy onlineBooking = ValueStrategy.unset();
    private ValueStrategy connectFromAnywhere = ValueStrategy.unset();
    private Party[] locations;
    private SecurityRole[] roles;
    private Entity[] departments;
    private Entity defaultDepartment;
    private Boolean signature;

    public TestUserBuilder(ArchetypeService service, UserRules userRules, TestDocumentFactory documentFactory) {
        super("security.user", User.class, service);
        this.userRules = userRules;
        this.documentFactory = documentFactory;
    }

    public TestUserBuilder(User object, ArchetypeService service, UserRules userRules, TestDocumentFactory documentFactory) {
        super(object, service);
        this.userRules = userRules;
        this.documentFactory = documentFactory;
    }

    public TestUserBuilder username(String username) {
        return this.username(ValueStrategy.value(username));
    }

    public TestUserBuilder username(ValueStrategy username) {
        this.username = username;
        return this;
    }

    public TestUserBuilder password(String password) {
        this.password = ValueStrategy.value(password);
        return this;
    }

    public TestUserBuilder changePassword(boolean changePassword) {
        this.changePassword = ValueStrategy.value(changePassword);
        return this;
    }

    public TestUserBuilder title(String titleCode) {
        this.titleCode = titleCode;
        return this;
    }

    public TestUserBuilder firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public TestUserBuilder lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public TestUserBuilder qualifications(String qualifications) {
        this.qualifications = qualifications;
        return this;
    }

    public TestUserBuilder clinician() {
        this.clinician = true;
        return this;
    }

    public TestUserBuilder administrator() {
        this.administrator = true;
        return this;
    }

    public TestUserBuilder onlineBooking() {
        return this.onlineBooking(true);
    }

    public TestUserBuilder connectFromAnywhere(boolean connectFromAnywhere) {
        this.connectFromAnywhere = ValueStrategy.value(connectFromAnywhere);
        return this;
    }

    public TestUserBuilder onlineBooking(boolean onlineBooking) {
        this.onlineBooking = ValueStrategy.value(onlineBooking);
        return this;
    }

    public TestUserBuilder addLocations(Party ... locations) {
        this.locations = locations;
        return this;
    }

    public TestUserBuilder addRoles(SecurityRole ... roles) {
        this.roles = roles;
        return this;
    }

    public TestUserBuilder addDepartments(Entity ... departments) {
        this.departments = departments;
        return this;
    }

    public TestUserBuilder defaultDepartment(Entity department) {
        this.defaultDepartment = department;
        return this;
    }

    public TestUserBuilder signature() {
        this.signature = true;
        return this;
    }

    @Override
    protected void build(User object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        Lookup title;
        super.build(object, bean, toSave, toRemove);
        Object usernameValue = this.username.setValue(bean, "username");
        Lookup lookup = title = this.titleCode != null ? (Lookup)((TestLookupBuilder)new TestLookupBuilder("lookup.personTitle", this.getService()).code(this.titleCode)).build() : null;
        if (this.getName().isUnset()) {
            if (this.firstName != null && this.lastName != null) {
                StringBuilder builder = new StringBuilder();
                if (title != null) {
                    builder.append(title.getName()).append(' ');
                }
                builder.append(this.firstName).append(' ').append(this.lastName);
                object.setName(builder.toString());
            } else if (usernameValue != null) {
                object.setName(usernameValue.toString());
            }
        }
        this.password.setValue(bean, "password");
        this.changePassword.setValue(bean, "changePassword");
        if (title != null) {
            bean.setValue("title", (Object)title.getCode());
        }
        if (this.firstName != null) {
            bean.setValue("firstName", (Object)this.firstName);
        }
        if (this.lastName != null) {
            bean.setValue("lastName", (Object)this.lastName);
        }
        if (this.qualifications != null) {
            bean.setValue("qualifications", (Object)this.qualifications);
        }
        if (this.clinician) {
            object.addClassification(this.getUserType("CLINICIAN"));
        }
        if (this.administrator) {
            object.addClassification(this.getUserType("ADMINISTRATOR"));
        }
        this.onlineBooking.setValue(bean, "onlineBooking");
        this.connectFromAnywhere.setValue(bean, "connectFromAnywhere");
        if (this.locations != null) {
            for (Party party : this.locations) {
                bean.addTarget("locations", (IMObject)party);
            }
        }
        if (this.roles != null) {
            for (Party party : this.roles) {
                bean.addValue("roles", (IMObject)party);
            }
        }
        if (this.departments != null) {
            for (Entity entity : this.departments) {
                bean.addTarget("departments", (IMObject)entity);
            }
        }
        if (this.defaultDepartment != null) {
            for (EntityLink link : bean.getValues("departments", EntityLink.class)) {
                IMObjectBean linkBean = this.getBean((IMObject)link);
                if (link.getTarget().equals((Object)this.defaultDepartment.getObjectReference())) {
                    linkBean.setValue("default", (Object)true);
                    continue;
                }
                linkBean.setValue("default", (Object)false);
            }
        }
        if (this.signature != null && this.signature.booleanValue()) {
            this.addSignature(object, toSave);
        }
    }

    private void addSignature(User object, Set<IMObject> toSave) {
        if (object.isNew() || this.userRules.getSignature(object) == null) {
            Document document = (Document)((TestDocumentBuilder)this.documentFactory.newDocument().name(ValueStrategy.suffix(".png"))).content(RandomUtils.nextBytes((int)10)).build(false);
            DocumentAct signature = this.create("act.documentSignature", DocumentAct.class);
            signature.setFileName(document.getName());
            IMObjectBean bean = this.getBean((IMObject)signature);
            bean.setTarget("user", (IMObject)object);
            signature.setDocument(document.getObjectReference());
            toSave.add((IMObject)document);
            toSave.add((IMObject)signature);
        }
    }

    private Lookup getUserType(String code) {
        return (Lookup)((TestLookupBuilder)new TestLookupBuilder("lookup.userType", this.getService()).code(code)).build();
    }
}

