/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.user;

import java.util.Set;
import org.openvpms.archetype.test.builder.object.AbstractTestIMObjectBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.business.domain.im.security.ArchetypeAwareGrantedAuthority;
import org.openvpms.component.business.domain.im.security.SecurityRole;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestRoleBuilder
extends AbstractTestIMObjectBuilder<SecurityRole, TestRoleBuilder> {
    private ArchetypeAwareGrantedAuthority[] authorities;

    public TestRoleBuilder(ArchetypeService service) {
        super("security.role", SecurityRole.class, service);
        this.name(ValueStrategy.random("zrole"));
    }

    public TestRoleBuilder authorities(ArchetypeAwareGrantedAuthority ... authorities) {
        this.authorities = authorities;
        return this;
    }

    @Override
    protected void build(SecurityRole object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.authorities != null) {
            for (ArchetypeAwareGrantedAuthority authority : this.authorities) {
                object.addAuthority(authority);
            }
        }
    }
}

