/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.supplier;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.test.builder.act.AbstractTestActBuilder;
import org.openvpms.archetype.test.builder.supplier.TestSupplierActItemBuilder;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public abstract class TestSupplierActBuilder<B extends TestSupplierActBuilder<B, I>, I extends TestSupplierActItemBuilder<B, I>>
extends AbstractTestActBuilder<FinancialAct, B> {
    private final List<FinancialAct> items = new ArrayList<FinancialAct>();
    private List<FinancialAct> builtItems = new ArrayList<FinancialAct>();
    private Party supplier;
    private Party stockLocation;

    public TestSupplierActBuilder(String archetype, ArchetypeService service) {
        super(archetype, FinancialAct.class, service);
    }

    public B supplier(Party supplier) {
        this.supplier = supplier;
        return (B)((TestSupplierActBuilder)this.getThis());
    }

    public B stockLocation(Party stockLocation) {
        this.stockLocation = stockLocation;
        return (B)((TestSupplierActBuilder)this.getThis());
    }

    public abstract I item();

    public B add(FinancialAct item) {
        this.items.add(item);
        return (B)((TestSupplierActBuilder)this.getThis());
    }

    public List<FinancialAct> getItems() {
        return this.builtItems;
    }

    @Override
    protected void build(FinancialAct object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.supplier != null) {
            bean.setTarget("supplier", (IMObject)this.supplier);
        }
        if (this.stockLocation != null) {
            bean.setTarget("stockLocation", (IMObject)this.stockLocation);
        }
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal total = BigDecimal.ZERO;
        for (FinancialAct item : this.items) {
            ActRelationship relationship = (ActRelationship)bean.addTarget("items", (IMObject)item);
            item.addActRelationship(relationship);
            toSave.add((IMObject)item);
            tax = tax.add(item.getTaxAmount());
            total = total.add(item.getTotal());
        }
        object.setTotal(tax);
        object.setTotal(total);
        this.builtItems = new ArrayList<FinancialAct>(this.items);
        this.items.clear();
    }
}

