/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.sms;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.test.builder.sms.AbstractTestSMSBuilder;
import org.openvpms.archetype.test.builder.sms.TestSMSReplyBuilder;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestSMSBuilder
extends AbstractTestSMSBuilder<TestSMSBuilder> {
    private final List<Reply> replies = new ArrayList<Reply>();
    private final List<Act> builtReplies = new ArrayList<Act>();
    private Party customer;
    private Party patient;
    private Act source;

    public TestSMSBuilder(ArchetypeService service) {
        super("act.smsMessage", service);
    }

    public TestSMSBuilder(Act object, ArchetypeService service) {
        super(object, service);
    }

    public TestSMSBuilder recipient(Party recipient) {
        return (TestSMSBuilder)this.contact(recipient);
    }

    public TestSMSBuilder customer(Party customer) {
        this.customer = customer;
        return this;
    }

    public TestSMSBuilder patient(Party patient) {
        this.patient = patient;
        return this;
    }

    public TestSMSBuilder updated(Date updated) {
        return (TestSMSBuilder)this.startTime(updated);
    }

    public TestSMSBuilder sent(Date sent) {
        return (TestSMSBuilder)this.endTime(sent);
    }

    public TestSMSBuilder source(Act source) {
        this.source = source;
        return this;
    }

    public TestSMSBuilder addReply(String message) {
        return this.addReply(new Date(), message);
    }

    public TestSMSBuilder addReply(Date received, String message) {
        this.replies.add(new Reply(received, message));
        return this;
    }

    public TestSMSBuilder addReply(Act reply) {
        this.replies.add(new Reply(reply));
        return this;
    }

    public List<Act> getReplies() {
        return this.builtReplies;
    }

    @Override
    protected void build(Act object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        this.builtReplies.clear();
        if (this.customer != null) {
            bean.setTarget("customer", (IMObject)this.customer);
        }
        if (this.patient != null) {
            bean.setTarget("patient", (IMObject)this.patient);
        }
        if (this.source != null) {
            ActRelationship relationship = this.create("actRelationship.smsSource", ActRelationship.class);
            relationship.setSource(this.source.getObjectReference());
            relationship.setTarget(bean.getReference());
            object.addActRelationship(relationship);
            this.source.addActRelationship(relationship);
            toSave.add((IMObject)this.source);
        }
        if (!this.replies.isEmpty()) {
            TestSMSReplyBuilder builder = new TestSMSReplyBuilder(this.getService());
            for (Reply reply : this.replies) {
                Act act = reply.act == null ? (Act)((TestSMSReplyBuilder)((TestSMSReplyBuilder)((TestSMSReplyBuilder)builder.sender(this.getContact()).location(this.getLocation())).phone(this.getPhone())).message(reply.message)).received(reply.received).build(false) : reply.act;
                bean.addTarget("replies", (IMObject)act, "sms");
                this.builtReplies.add(act);
                toSave.add((IMObject)act);
            }
            this.replies.clear();
        }
    }

    private static class Reply {
        private final Date received;
        private final String message;
        private final Act act;

        public Reply(Date received, String message) {
            this(received, message, null);
        }

        public Reply(Act reply) {
            this(null, null, reply);
        }

        private Reply(Date received, String message, Act reply) {
            this.received = received;
            this.message = message;
            this.act = reply;
        }
    }
}

