/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.scheduling;

import java.util.Set;
import org.openvpms.archetype.test.builder.entity.AbstractTestEntityBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestScheduleViewBuilder
extends AbstractTestEntityBuilder<Entity, TestScheduleViewBuilder> {
    private Entity[] schedules;

    public TestScheduleViewBuilder(ArchetypeService service) {
        super("entity.organisationScheduleView", Entity.class, service);
        this.name(ValueStrategy.random("zscheduleview"));
    }

    public TestScheduleViewBuilder schedules(Entity ... schedules) {
        this.schedules = schedules;
        return this;
    }

    @Override
    protected void build(Entity object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.schedules != null) {
            int sequence = bean.getValues("schedules").size();
            for (Entity schedule : this.schedules) {
                EntityRelationship relationship = (EntityRelationship)bean.addTarget("schedules", (IMObject)schedule, "views");
                relationship.setSequence(sequence++);
                toSave.add((IMObject)schedule);
            }
        }
    }
}

