/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.scheduling;

import java.util.Set;
import org.openvpms.archetype.rules.workflow.ScheduleArchetypes;
import org.openvpms.archetype.test.builder.entity.AbstractTestEntityBuilder;
import org.openvpms.archetype.test.builder.lookup.TestLookupBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestAppointmentTypeBuilder
extends AbstractTestEntityBuilder<Entity, TestAppointmentTypeBuilder> {
    private ValueStrategy reason = ValueStrategy.unset();
    private ValueStrategy onlineBooking = ValueStrategy.unset();
    private ValueStrategy sendReminders = ValueStrategy.unset();

    public TestAppointmentTypeBuilder(ArchetypeService service) {
        super("entity.appointmentType", Entity.class, service);
        this.name(ValueStrategy.random("zappointmenttype"));
    }

    public TestAppointmentTypeBuilder(Entity object, ArchetypeService service) {
        super(object, service);
    }

    public TestAppointmentTypeBuilder reason(String reason) {
        this.reason = ValueStrategy.value(reason);
        return this;
    }

    public TestAppointmentTypeBuilder onlineBooking() {
        return this.onlineBooking(true);
    }

    public TestAppointmentTypeBuilder onlineBooking(boolean onlineBooking) {
        this.onlineBooking = ValueStrategy.value(onlineBooking);
        return this;
    }

    public TestAppointmentTypeBuilder sendReminders(boolean sendReminders) {
        this.sendReminders = ValueStrategy.value(sendReminders);
        return this;
    }

    @Override
    protected void build(Entity object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.reason.isSet()) {
            if (this.reason.getValue() != null) {
                String code = this.reason.toString();
                Lookup lookup = (Lookup)((TestLookupBuilder)new TestLookupBuilder(ScheduleArchetypes.VISIT_REASON, this.getService()).code(code)).build();
                object.addClassification(lookup);
            } else {
                bean.removeValues("reason");
            }
        }
        this.onlineBooking.setValue(bean, "onlineBooking");
        this.sendReminders.setValue(bean, "sendReminders");
    }
}

