/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.scheduling;

import java.util.Set;
import org.openvpms.archetype.test.builder.act.AbstractTestActBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;

public class AbstractTestScheduleActBuilder<B extends AbstractTestScheduleActBuilder<B>>
extends AbstractTestActBuilder<Act, B> {
    private Party customer;
    private Party patient;
    private User clinician;
    private ValueStrategy notes = ValueStrategy.unset();

    public AbstractTestScheduleActBuilder(String archetype, ArchetypeService service) {
        super(archetype, Act.class, service);
    }

    public AbstractTestScheduleActBuilder(Act object, ArchetypeService service) {
        super(object, service);
        IMObjectBean bean = this.getBean((IMObject)object);
        this.customer = (Party)bean.getTarget("customer", Party.class);
        this.patient = (Party)bean.getTarget("patient", Party.class);
    }

    public B customer(Party customer) {
        this.customer = customer;
        return (B)((AbstractTestScheduleActBuilder)this.getThis());
    }

    public Party getCustomer() {
        return this.customer;
    }

    public B patient(Party patient) {
        this.patient = patient;
        return (B)((AbstractTestScheduleActBuilder)this.getThis());
    }

    public Party getPatient() {
        return this.patient;
    }

    public B clinician(User clinician) {
        this.clinician = clinician;
        return (B)((AbstractTestScheduleActBuilder)this.getThis());
    }

    public B notes(String notes) {
        this.notes = ValueStrategy.value(notes);
        return (B)((AbstractTestScheduleActBuilder)this.getThis());
    }

    @Override
    protected void build(Act object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.customer != null) {
            bean.setTarget("customer", (IMObject)this.customer);
        }
        if (this.patient != null) {
            bean.setTarget("patient", (IMObject)this.patient);
        }
        if (this.clinician != null) {
            bean.setTarget("clinician", (IMObject)this.clinician);
        }
        this.notes.setValue(bean, "notes");
    }
}

