/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.product;

import java.math.BigDecimal;
import java.util.Set;
import org.openvpms.archetype.test.builder.object.AbstractTestIMObjectBuilder;
import org.openvpms.archetype.test.builder.product.TestTemplateProductBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestTemplateIncludeBuilder
extends AbstractTestIMObjectBuilder<EntityLink, TestTemplateIncludeBuilder> {
    private final TestTemplateProductBuilder parent;
    private Product product;
    private BigDecimal lowQuantity;
    private BigDecimal highQuantity;
    private BigDecimal minWeight;
    private BigDecimal maxWeight;
    private Boolean print;
    private Boolean zeroPrice;
    private Boolean skipIfMissing;

    public TestTemplateIncludeBuilder(TestTemplateProductBuilder parent, ArchetypeService service) {
        super("entityLink.productIncludes", EntityLink.class, service);
        this.parent = parent;
    }

    public TestTemplateIncludeBuilder product(Product product) {
        this.product = product;
        return this;
    }

    public TestTemplateIncludeBuilder quantity(int quantity) {
        return this.quantity(BigDecimal.valueOf(quantity));
    }

    public TestTemplateIncludeBuilder quantity(BigDecimal quantity) {
        return this.lowQuantity(quantity).highQuantity(quantity);
    }

    public TestTemplateIncludeBuilder lowQuantity(int lowQuantity) {
        return this.lowQuantity(BigDecimal.valueOf(lowQuantity));
    }

    public TestTemplateIncludeBuilder lowQuantity(BigDecimal lowQuantity) {
        this.lowQuantity = lowQuantity;
        return this;
    }

    public TestTemplateIncludeBuilder highQuantity(int highQuantity) {
        return this.highQuantity(BigDecimal.valueOf(highQuantity));
    }

    public TestTemplateIncludeBuilder highQuantity(BigDecimal highQuantity) {
        this.highQuantity = highQuantity;
        return this;
    }

    public TestTemplateIncludeBuilder minWeight(int minWeight) {
        return this.minWeight(BigDecimal.valueOf(minWeight));
    }

    public TestTemplateIncludeBuilder minWeight(BigDecimal minWeight) {
        this.minWeight = minWeight;
        return this;
    }

    public TestTemplateIncludeBuilder maxWeight(int maxWeight) {
        return this.maxWeight(BigDecimal.valueOf(maxWeight));
    }

    public TestTemplateIncludeBuilder maxWeight(BigDecimal maxWeight) {
        this.maxWeight = maxWeight;
        return this;
    }

    public TestTemplateIncludeBuilder print(boolean print) {
        this.print = print;
        return this;
    }

    public TestTemplateIncludeBuilder zeroPrice() {
        return this.zeroPrice(true);
    }

    public TestTemplateIncludeBuilder zeroPrice(boolean zeroPrice) {
        this.zeroPrice = zeroPrice;
        return this;
    }

    public TestTemplateIncludeBuilder skipIfMissing(boolean skipIfMissing) {
        this.skipIfMissing = skipIfMissing;
        return this;
    }

    public TestTemplateProductBuilder add() {
        EntityLink include = (EntityLink)this.build(false);
        this.parent.include(include);
        return this.parent;
    }

    @Override
    protected void build(EntityLink object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.product != null) {
            object.setTarget(this.product.getObjectReference());
        }
        if (this.lowQuantity != null) {
            bean.setValue("lowQuantity", (Object)this.lowQuantity);
        }
        if (this.highQuantity != null) {
            bean.setValue("highQuantity", (Object)this.highQuantity);
        }
        if (this.minWeight != null) {
            bean.setValue("minWeight", (Object)this.minWeight);
        }
        if (this.maxWeight != null) {
            bean.setValue("maxWeight", (Object)this.maxWeight);
        }
        if (this.print != null) {
            bean.setValue("print", (Object)this.print);
        }
        if (this.zeroPrice != null) {
            bean.setValue("zeroPrice", (Object)this.zeroPrice);
        }
        if (this.skipIfMissing != null) {
            bean.setValue("skipIfMissing", (Object)this.skipIfMissing);
        }
    }
}

