/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.product;

import java.math.BigDecimal;
import java.util.Set;
import org.openvpms.archetype.test.builder.object.AbstractTestIMObjectBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.product.TestProductBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestProductStockLocationBuilder<P extends TestProductBuilder<P>>
extends AbstractTestIMObjectBuilder<EntityLink, TestProductStockLocationBuilder<P>> {
    private final P parent;
    private Party stockLocation;
    private ValueStrategy quantity = ValueStrategy.unset();
    private ValueStrategy idealQuantity = ValueStrategy.unset();
    private ValueStrategy criticalQuantity = ValueStrategy.unset();
    private ValueStrategy supplier = ValueStrategy.unset();

    public TestProductStockLocationBuilder(P parent, ArchetypeService service) {
        super("entityLink.productStockLocation", EntityLink.class, service);
        this.parent = parent;
    }

    public TestProductStockLocationBuilder(P parent, EntityLink object, ArchetypeService service) {
        super(object, service);
        this.parent = parent;
    }

    public TestProductStockLocationBuilder<P> stockLocation(Party stockLocation) {
        this.stockLocation = stockLocation;
        return this;
    }

    public TestProductStockLocationBuilder<P> quantity(int quantity) {
        return this.quantity(BigDecimal.valueOf(quantity));
    }

    public TestProductStockLocationBuilder<P> quantity(BigDecimal quantity) {
        this.quantity = ValueStrategy.value(quantity);
        return (TestProductStockLocationBuilder)this.getThis();
    }

    public TestProductStockLocationBuilder<P> idealQuantity(int idealQuantity) {
        return this.idealQuantity(BigDecimal.valueOf(idealQuantity));
    }

    public TestProductStockLocationBuilder<P> idealQuantity(BigDecimal idealQuantity) {
        this.idealQuantity = ValueStrategy.value(idealQuantity);
        return (TestProductStockLocationBuilder)this.getThis();
    }

    public TestProductStockLocationBuilder<P> criticalQuantity(int criticalQuantity) {
        return this.criticalQuantity(BigDecimal.valueOf(criticalQuantity));
    }

    public TestProductStockLocationBuilder<P> criticalQuantity(BigDecimal criticalQuantity) {
        this.criticalQuantity = ValueStrategy.value(criticalQuantity);
        return (TestProductStockLocationBuilder)this.getThis();
    }

    public TestProductStockLocationBuilder<P> supplier(Party supplier) {
        this.supplier = ValueStrategy.value(supplier != null ? supplier.getObjectReference() : null);
        return (TestProductStockLocationBuilder)this.getThis();
    }

    public TestProductStockLocationBuilder<P> copy(EntityLink productStockLocation) {
        IMObjectBean bean = this.getBean((IMObject)productStockLocation);
        this.stockLocation((Party)this.getService().get(productStockLocation.getTarget(), Party.class));
        this.quantity(bean.getBigDecimal("quantity"));
        this.idealQuantity(bean.getBigDecimal("idealQty"));
        this.criticalQuantity(bean.getBigDecimal("criticalQty"));
        return this.supplier((Party)bean.getObject("supplier", Party.class));
    }

    @Override
    public EntityLink build() {
        return (EntityLink)this.build(false);
    }

    public P add() {
        return (P)((TestProductBuilder)this.parent).addProductStockLocation(this.build());
    }

    @Override
    protected void build(EntityLink object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.stockLocation != null) {
            object.setTarget(this.stockLocation.getObjectReference());
        }
        this.quantity.setValue(bean, "quantity");
        this.idealQuantity.setValue(bean, "idealQty");
        this.criticalQuantity.setValue(bean, "criticalQty");
        this.supplier.setValue(bean, "supplier");
    }
}

