/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.product;

import java.math.BigDecimal;
import java.util.Set;
import org.openvpms.archetype.test.builder.entity.AbstractTestEntityBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestDiscountBuilder
extends AbstractTestEntityBuilder<Entity, TestDiscountBuilder> {
    private ValueStrategy rate = ValueStrategy.unset();
    private ValueStrategy type = ValueStrategy.unset();
    private ValueStrategy discountFixedPrice = ValueStrategy.unset();

    public TestDiscountBuilder(ArchetypeService service) {
        super("entity.discountType", Entity.class, service);
        this.name(ValueStrategy.random("zdiscount"));
    }

    public TestDiscountBuilder percentage(int rate) {
        return this.rate(BigDecimal.valueOf(rate), "PERCENTAGE");
    }

    public TestDiscountBuilder percentage(BigDecimal rate) {
        return this.rate(rate, "PERCENTAGE");
    }

    public TestDiscountBuilder fixed(BigDecimal rate) {
        return this.rate(rate, "FIXED");
    }

    public TestDiscountBuilder costRate(BigDecimal rate) {
        return this.rate(rate, "COST_RATE");
    }

    public TestDiscountBuilder discountFixedPrice(boolean discountFixedPrice) {
        this.discountFixedPrice = ValueStrategy.value(discountFixedPrice);
        return this;
    }

    @Override
    protected void build(Entity object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        this.rate.setValue(bean, "rate");
        this.type.setValue(bean, "type");
        this.discountFixedPrice.setValue(bean, "discountFixed");
    }

    private TestDiscountBuilder rate(BigDecimal rate, String type) {
        this.rate = ValueStrategy.value(rate);
        this.type = ValueStrategy.value(type);
        return this;
    }
}

