/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.product;

import java.util.Date;
import java.util.Set;
import org.openvpms.archetype.test.builder.entity.AbstractTestEntityBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestBatchBuilder
extends AbstractTestEntityBuilder<Entity, TestBatchBuilder> {
    private ValueStrategy expiryDate = ValueStrategy.unset();
    private Product product;
    private Entity[] stockLocations;

    public TestBatchBuilder(ArchetypeService service) {
        super("entity.productBatch", Entity.class, service);
    }

    public TestBatchBuilder(Entity batch, ArchetypeService service) {
        super(batch, service);
    }

    public TestBatchBuilder batchNo(String batchNo) {
        return (TestBatchBuilder)this.name(batchNo);
    }

    public TestBatchBuilder expiryDate(Date expiryDate) {
        this.expiryDate = ValueStrategy.value(expiryDate);
        return this;
    }

    public TestBatchBuilder product(Product product) {
        this.product = product;
        return this;
    }

    public TestBatchBuilder addStockLocations(Entity ... stockLocations) {
        this.stockLocations = stockLocations;
        return this;
    }

    @Override
    protected void build(Entity object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        Relationship relationship = this.product != null ? bean.setTarget("product", (IMObject)this.product) : (Relationship)bean.getObject("product", Relationship.class);
        if (this.expiryDate.isSet()) {
            this.expiryDate.setValue(this.getBean((IMObject)relationship), "activeEndTime");
        }
        if (this.stockLocations != null) {
            for (Entity stockLocation : this.stockLocations) {
                bean.addTarget("stockLocations", (IMObject)stockLocation);
            }
        }
    }
}

