/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.practice;

import java.util.Set;
import org.openvpms.archetype.test.builder.entity.AbstractTestEntityBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestTillBuilder
extends AbstractTestEntityBuilder<Entity, TestTillBuilder> {
    private ValueStrategy printer = ValueStrategy.unset();
    private ValueStrategy drawerCommand = ValueStrategy.unset();
    private Entity[] terminals;

    public TestTillBuilder(ArchetypeService service) {
        super("party.organisationTill", Entity.class, service);
        this.name(ValueStrategy.random("ztill"));
    }

    public TestTillBuilder(Entity object, ArchetypeService service) {
        super(object, service);
    }

    public TestTillBuilder printer(String printer) {
        this.printer = ValueStrategy.value(printer);
        return this;
    }

    public TestTillBuilder drawerCommand(String drawerCommand) {
        this.drawerCommand = ValueStrategy.value(drawerCommand);
        return this;
    }

    public TestTillBuilder terminals(Entity ... terminals) {
        this.terminals = terminals;
        return this;
    }

    @Override
    protected void build(Entity object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        this.printer.setValue(bean, "printerName");
        this.drawerCommand.setValue(bean, "drawerCommand");
        if (this.terminals != null) {
            for (Entity terminal : this.terminals) {
                bean.addTarget("terminals", (IMObject)terminal);
            }
        }
    }
}

