/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.practice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.test.builder.entity.AbstractTestEntityBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestDepartmentBuilder
extends AbstractTestEntityBuilder<Entity, TestDepartmentBuilder> {
    private final List<EntityLink> serviceRatios = new ArrayList<EntityLink>();

    public TestDepartmentBuilder(ArchetypeService service) {
        super("entity.department", Entity.class, service);
        this.name(ValueStrategy.random("zdepartment"));
    }

    public TestDepartmentBuilder(Entity object, ArchetypeService service) {
        super(object, service);
    }

    public TestDepartmentBuilder addServiceRatio(Entity productType, int ratio) {
        return this.addServiceRatio(productType, BigDecimal.valueOf(ratio));
    }

    public TestDepartmentBuilder addServiceRatio(Entity productType, BigDecimal ratio) {
        return this.addServiceRatio(productType, ratio, null);
    }

    public TestDepartmentBuilder addServiceRatio(Entity productType, BigDecimal ratio, Entity calendar) {
        EntityLink link = this.create(this.getNodeArchetype("serviceRatios"), EntityLink.class);
        link.setTarget(productType.getObjectReference());
        IMObjectBean bean = this.getBean((IMObject)link);
        bean.setValue("ratio", (Object)ratio);
        if (calendar != null) {
            bean.setValue("calendar", (Object)calendar.getObjectReference());
        }
        this.serviceRatios.add(link);
        return this;
    }

    @Override
    protected void build(Entity object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        for (EntityLink serviceRatio : this.serviceRatios) {
            serviceRatio.setSource(object.getObjectReference());
            bean.addValue("serviceRatios", (IMObject)serviceRatio);
        }
        this.serviceRatios.clear();
    }
}

