/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.patient.reminder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.archetype.test.builder.patient.AbstractTestPatientActBuilder;
import org.openvpms.archetype.test.builder.patient.reminder.TestReminderItemBuilder;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestReminderBuilder
extends AbstractTestPatientActBuilder<Act, TestReminderBuilder> {
    private final ReminderRules rules;
    private final List<Act> items = new ArrayList<Act>();
    private Date date;
    private Date dueDate;
    private Date nextDueDate;
    private Entity reminderType;
    private int count;
    private Product product;
    private List<Act> builtItems = Collections.emptyList();

    public TestReminderBuilder(ReminderRules reminderRules, ArchetypeService service) {
        super("act.patientReminder", Act.class, service);
        this.rules = reminderRules;
    }

    public TestReminderBuilder(Act object, ReminderRules reminderRules, ArchetypeService service) {
        super(object, service);
        this.rules = reminderRules;
        IMObjectBean bean = this.getBean((IMObject)object);
        this.date(bean.getDate("initialTime"));
        this.nextDueDate(object.getActivityStartTime());
        this.endTime(object.getActivityEndTime());
        this.reminderType((Entity)bean.getTarget("reminderType", Entity.class));
    }

    public TestReminderBuilder date(String date) {
        return this.date(this.parseDate(date));
    }

    public TestReminderBuilder date(Date date) {
        this.date = date;
        return this;
    }

    public TestReminderBuilder dueDate(String dueDate) {
        return this.dueDate(this.parseDate(dueDate));
    }

    public TestReminderBuilder dueDate(Date dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    public TestReminderBuilder nextDueDate(Date nextDueDate) {
        this.nextDueDate = nextDueDate;
        return this;
    }

    public TestReminderBuilder reminderType(Entity reminderType) {
        this.reminderType = reminderType;
        return this;
    }

    public TestReminderBuilder count(int count) {
        this.count = count;
        return this;
    }

    public TestReminderBuilder addItems(Act ... items) {
        this.items.addAll(Arrays.asList(items));
        return this;
    }

    public TestReminderBuilder product(Product product) {
        this.product = product;
        return this;
    }

    public TestReminderItemBuilder newEmailReminder() {
        return new TestReminderItemBuilder(this, "act.patientReminderItemEmail", this.getService());
    }

    public TestReminderItemBuilder newExportReminder() {
        return new TestReminderItemBuilder(this, "act.patientReminderItemExport", this.getService());
    }

    public TestReminderItemBuilder newListReminder() {
        return new TestReminderItemBuilder(this, "act.patientReminderItemList", this.getService());
    }

    public TestReminderItemBuilder newPrintReminder() {
        return new TestReminderItemBuilder(this, "act.patientReminderItemPrint", this.getService());
    }

    public TestReminderItemBuilder newSMSReminder() {
        return new TestReminderItemBuilder(this, "act.patientReminderItemSMS", this.getService());
    }

    public List<Act> getItems() {
        return this.builtItems;
    }

    @Override
    protected void build(Act object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        Date nextDue;
        Date initial = this.date != null ? this.date : new Date();
        Date due = this.dueDate != null ? this.dueDate : this.rules.calculateReminderDueDate(initial, this.reminderType);
        this.endTime(due);
        Date date = nextDue = this.nextDueDate != null ? this.nextDueDate : this.rules.getNextReminderDate(due, this.reminderType, this.count);
        if (nextDue == null) {
            nextDue = due;
        }
        this.startTime(nextDue);
        super.build(object, bean, toSave, toRemove);
        bean.setValue("initialTime", (Object)initial);
        bean.setTarget("reminderType", (IMObject)this.reminderType);
        if (this.product != null) {
            bean.setTarget("product", (IMObject)this.product);
        }
        for (Act item : this.items) {
            bean.addTarget("items", (IMObject)item, "reminder");
            toSave.add((IMObject)item);
        }
        this.builtItems = new ArrayList<Act>(this.items);
        this.items.clear();
    }
}

