/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.patient;

import java.math.BigDecimal;
import java.util.Set;
import org.openvpms.archetype.test.builder.patient.AbstractTestPatientActBuilder;
import org.openvpms.component.math.WeightUnits;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestWeightBuilder
extends AbstractTestPatientActBuilder<Act, TestWeightBuilder> {
    private BigDecimal weight;
    private WeightUnits units;

    public TestWeightBuilder(ArchetypeService service) {
        super("act.patientWeight", Act.class, service);
    }

    public TestWeightBuilder weight(int weight) {
        return this.weight(BigDecimal.valueOf(weight));
    }

    public TestWeightBuilder weight(BigDecimal weight) {
        return this.weight(weight, null);
    }

    public TestWeightBuilder weight(int weight, WeightUnits units) {
        return this.weight(BigDecimal.valueOf(weight), units);
    }

    public TestWeightBuilder weight(BigDecimal weight, WeightUnits units) {
        this.weight = weight;
        this.units = units;
        return this;
    }

    @Override
    protected void build(Act object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.weight != null) {
            bean.setValue("weight", (Object)this.weight);
        }
        if (this.units != null) {
            bean.setValue("units", (Object)this.units.toString());
        }
    }
}

