/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.patient;

import java.math.BigDecimal;
import org.openvpms.archetype.rules.laboratory.LaboratoryRules;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.entity.TestEntityIdentityBuilder;
import org.openvpms.archetype.test.builder.patient.TestAddendumBuilder;
import org.openvpms.archetype.test.builder.patient.TestAttachmentBuilder;
import org.openvpms.archetype.test.builder.patient.TestCustomerNoteBuilder;
import org.openvpms.archetype.test.builder.patient.TestImageBuilder;
import org.openvpms.archetype.test.builder.patient.TestInvestigationBuilder;
import org.openvpms.archetype.test.builder.patient.TestLetterBuilder;
import org.openvpms.archetype.test.builder.patient.TestLinkBuilder;
import org.openvpms.archetype.test.builder.patient.TestNoteBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientAlertBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientAlertTypeBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFormBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientMedicationBuilder;
import org.openvpms.archetype.test.builder.patient.TestPrescriptionBuilder;
import org.openvpms.archetype.test.builder.patient.TestProblemBuilder;
import org.openvpms.archetype.test.builder.patient.TestVisitBuilder;
import org.openvpms.archetype.test.builder.patient.TestWeightBuilder;
import org.openvpms.component.math.WeightUnits;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityIdentity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestPatientFactory {
    private final ArchetypeService service;
    private final LaboratoryRules laboratoryRules;
    private final TestDocumentFactory documentFactory;

    public TestPatientFactory(ArchetypeService service, LaboratoryRules laboratoryRules, TestDocumentFactory documentFactory) {
        this.service = service;
        this.laboratoryRules = laboratoryRules;
        this.documentFactory = documentFactory;
    }

    public Act createAlert(Party patient, Entity alertType) {
        return (Act)((TestPatientAlertBuilder)this.newAlert().patient(patient)).alertType(alertType).build();
    }

    public TestPatientAlertBuilder newAlert() {
        return new TestPatientAlertBuilder(this.service);
    }

    public Entity createAlertType() {
        return (Entity)this.newAlertType().build();
    }

    public Entity createAlertType(String name) {
        return (Entity)((TestPatientAlertTypeBuilder)this.newAlertType().name(name)).build();
    }

    public Entity createAlertType(String name, String alertType) {
        return (Entity)((TestPatientAlertTypeBuilder)this.newAlertType().name(name)).alertType(alertType).build();
    }

    public TestPatientAlertTypeBuilder newAlertType() {
        return new TestPatientAlertTypeBuilder(this.service);
    }

    public Party createPatient() {
        return (Party)this.newPatient().build();
    }

    public Party createPatient(Party owner) {
        return (Party)this.newPatient().owner(owner).build();
    }

    public Party createPatient(String name, Party owner) {
        return (Party)((TestPatientBuilder)this.newPatient().name(name)).owner(owner).build();
    }

    public TestPatientBuilder newPatient() {
        return new TestPatientBuilder(this.service);
    }

    public TestPatientBuilder updatePatient(Party patient) {
        return new TestPatientBuilder(patient, this.service);
    }

    public EntityIdentity createMicrochip(String microchip) {
        return new TestEntityIdentityBuilder("entityIdentity.microchip", this.service).identity(microchip).build();
    }

    public EntityIdentity createPetTag(String tag) {
        return new TestEntityIdentityBuilder("entityIdentity.petTag", this.service).identity(tag).build();
    }

    public EntityIdentity createRabiesTag(String tag) {
        return new TestEntityIdentityBuilder("entityIdentity.rabiesTag", this.service).identity(tag).build();
    }

    public DocumentAct createAddendum(Party patient, String note) {
        return (DocumentAct)((TestAddendumBuilder)((TestAddendumBuilder)this.newAddendum().patient(patient)).note(note)).build();
    }

    public TestAddendumBuilder newAddendum() {
        return new TestAddendumBuilder(this.service);
    }

    public TestAttachmentBuilder newAttachment() {
        return new TestAttachmentBuilder(this.service);
    }

    public TestAttachmentBuilder updateAttachment(DocumentAct attachment) {
        return new TestAttachmentBuilder(attachment, this.service);
    }

    public Act createCustomerNote(Party patient, String note) {
        return (Act)((TestCustomerNoteBuilder)this.newCustomerNote().patient(patient)).note(note).build();
    }

    public TestCustomerNoteBuilder newCustomerNote() {
        return new TestCustomerNoteBuilder(this.service);
    }

    public TestImageBuilder newImage() {
        return new TestImageBuilder(this.service);
    }

    public TestImageBuilder updateImage(DocumentAct image) {
        return new TestImageBuilder(image, this.service);
    }

    public TestInvestigationBuilder newInvestigation() {
        return new TestInvestigationBuilder(this.service, this.laboratoryRules);
    }

    public TestInvestigationBuilder updateInvestigation(DocumentAct investigation) {
        return new TestInvestigationBuilder(investigation, this.service, this.laboratoryRules);
    }

    public TestLetterBuilder newLetter() {
        return new TestLetterBuilder(this.service);
    }

    public TestLetterBuilder updateLetter(DocumentAct letter) {
        return new TestLetterBuilder(letter, this.service);
    }

    public Act createLink(Party patient, String url) {
        return (Act)((TestLinkBuilder)this.newLink().patient(patient)).url(url).build();
    }

    public TestLinkBuilder newLink() {
        return new TestLinkBuilder(this.service);
    }

    public Act createVisit(Party patient) {
        return (Act)((TestVisitBuilder)new TestVisitBuilder(this.service).patient(patient)).build();
    }

    public Act createVisit(Party patient, Party location) {
        return (Act)((TestVisitBuilder)((TestVisitBuilder)new TestVisitBuilder(this.service).patient(patient)).location(location)).build();
    }

    public TestVisitBuilder newVisit() {
        return new TestVisitBuilder(this.service);
    }

    public TestVisitBuilder updateVisit(Act visit) {
        return new TestVisitBuilder(visit, this.service);
    }

    public DocumentAct createForm(Party patient) {
        return (DocumentAct)((TestPatientFormBuilder)this.newForm().patient(patient)).template().build();
    }

    public DocumentAct createForm(Party patient, Entity template) {
        return (DocumentAct)((TestPatientFormBuilder)this.newForm().patient(patient)).template(template).build();
    }

    public TestPatientFormBuilder newForm() {
        return new TestPatientFormBuilder(this.service, this.documentFactory);
    }

    public Act createWeight(Party patient, int weight) {
        return this.createWeight(patient, BigDecimal.valueOf(weight), WeightUnits.KILOGRAMS);
    }

    public Act createWeight(Party patient, BigDecimal weight) {
        return this.createWeight(patient, weight, WeightUnits.KILOGRAMS);
    }

    public Act createWeight(Party patient, BigDecimal weight, WeightUnits units) {
        return (Act)((TestWeightBuilder)new TestWeightBuilder(this.service).patient(patient)).weight(weight, units).build();
    }

    public TestWeightBuilder newWeight() {
        return new TestWeightBuilder(this.service);
    }

    public Act createMedication(Party patient, Product product) {
        return (Act)((TestPatientMedicationBuilder)this.newMedication().patient(patient)).product(product).build();
    }

    public TestPatientMedicationBuilder newMedication() {
        return new TestPatientMedicationBuilder(this.service);
    }

    public DocumentAct createNote(Party patient, String note) {
        return (DocumentAct)((TestNoteBuilder)((TestNoteBuilder)this.newNote().patient(patient)).note(note)).build();
    }

    public TestNoteBuilder newNote() {
        return new TestNoteBuilder(this.service);
    }

    public TestNoteBuilder updateNote(DocumentAct note) {
        return new TestNoteBuilder(note, this.service);
    }

    public TestPrescriptionBuilder newPrescription() {
        return new TestPrescriptionBuilder(this.service);
    }

    public TestProblemBuilder newProblem() {
        return new TestProblemBuilder(this.service);
    }

    public TestProblemBuilder updateProblem(Act problem) {
        return new TestProblemBuilder(problem, this.service);
    }
}

