/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.patient;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.entity.TestEntityIdentityBuilder;
import org.openvpms.archetype.test.builder.lookup.TestLookupBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.party.AbstractTestPartyBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityIdentity;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.PeriodRelationship;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestPatientBuilder
extends AbstractTestPartyBuilder<Party, TestPatientBuilder> {
    public static final String SEX_MALE = "MALE";
    public static final String SEX_FEMALE = "FEMALE";
    public static final String SEX_UNSPECIFIED = "UNSPECIFIED";
    private final List<String> microchips = new ArrayList<String>();
    private final List<String> petTags = new ArrayList<String>();
    private final List<String> rabiesTags = new ArrayList<String>();
    private final List<String> aliases = new ArrayList<String>();
    private final List<CustomerRelationship> locations = new ArrayList<CustomerRelationship>();
    private final List<CustomerRelationship> owners = new ArrayList<CustomerRelationship>();
    private final List<Referral> referrals = new ArrayList<Referral>();
    private ValueStrategy species = ValueStrategy.unset();
    private ValueStrategy breed = ValueStrategy.unset();
    private ValueStrategy newBreed = ValueStrategy.unset();
    private ValueStrategy dateOfBirth = ValueStrategy.unset();
    private ValueStrategy sex = ValueStrategy.unset();
    private ValueStrategy desexed = ValueStrategy.unset();
    private ValueStrategy deceased = ValueStrategy.unset();
    private ValueStrategy dateOfDeath = ValueStrategy.unset();
    private ValueStrategy colour = ValueStrategy.unset();
    private ValueStrategy cageCode = ValueStrategy.unset();
    private Entity[] discounts;

    public TestPatientBuilder(ArchetypeService service) {
        super("party.patientpet", Party.class, service);
        this.name(ValueStrategy.random("Spot-"));
        this.species("CANINE");
    }

    public TestPatientBuilder(Party object, ArchetypeService service) {
        super(object, service);
    }

    public TestPatientBuilder species(String species) {
        this.species = ValueStrategy.value(species);
        return this;
    }

    public TestPatientBuilder breed(String breed) {
        this.breed = ValueStrategy.value(breed);
        return this;
    }

    public TestPatientBuilder newBreed(String newBreed) {
        this.newBreed = ValueStrategy.value(newBreed);
        return this;
    }

    public TestPatientBuilder male() {
        return this.sex(SEX_MALE);
    }

    public TestPatientBuilder female() {
        return this.sex(SEX_FEMALE);
    }

    public TestPatientBuilder unspecifiedSex() {
        return this.sex(SEX_UNSPECIFIED);
    }

    public TestPatientBuilder sex(String sex) {
        this.sex = ValueStrategy.value(sex);
        return this;
    }

    public TestPatientBuilder desexed(boolean desexed) {
        this.desexed = ValueStrategy.value(desexed);
        return this;
    }

    public TestPatientBuilder dateOfBirth(String dateOfBirth) {
        return this.dateOfBirth(this.parseDate(dateOfBirth));
    }

    public TestPatientBuilder dateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = ValueStrategy.value(dateOfBirth);
        return this;
    }

    public TestPatientBuilder age(int age, DateUnits units) {
        return this.dateOfBirth(DateRules.getDate((Date)DateRules.getToday(), (int)(-age), (DateUnits)units));
    }

    public TestPatientBuilder deceased(boolean deceased) {
        this.deceased = ValueStrategy.value(deceased);
        return this;
    }

    public TestPatientBuilder dateOfDeath(String dateOfDeath) {
        return this.dateOfDeath(this.parseDate(dateOfDeath));
    }

    public TestPatientBuilder dateOfDeath(Date dateOfDeath) {
        this.dateOfDeath = ValueStrategy.value(dateOfDeath);
        return this;
    }

    public TestPatientBuilder colour(String colour) {
        this.colour = ValueStrategy.value(colour);
        return this;
    }

    public TestPatientBuilder cage(String cageCode) {
        this.cageCode = ValueStrategy.value(cageCode);
        return this;
    }

    public TestPatientBuilder addLocation(Party customer, Date startTime, Date endTime) {
        this.locations.add(new CustomerRelationship(customer, startTime, endTime));
        return this;
    }

    public TestPatientBuilder owner(Party owner) {
        return this.addOwner(owner, new Date(), null);
    }

    public TestPatientBuilder addOwner(Party owner, Date startTime, Date endTime) {
        this.owners.add(new CustomerRelationship(owner, startTime, endTime));
        return this;
    }

    public TestPatientBuilder addMicrochip(String microchip) {
        this.microchips.add(microchip);
        return this;
    }

    public TestPatientBuilder addPetTag(String petTag) {
        this.petTags.add(petTag);
        return this;
    }

    public TestPatientBuilder addRabiesTag(String rabiesTag) {
        this.rabiesTags.add(rabiesTag);
        return this;
    }

    public TestPatientBuilder addAlias(String alias) {
        this.aliases.add(alias);
        return this;
    }

    public TestPatientBuilder addDiscounts(Entity ... discounts) {
        this.discounts = discounts;
        return this;
    }

    public TestPatientBuilder addReferredFrom(Party vet) {
        return this.addReferredFrom(vet, new Date());
    }

    public TestPatientBuilder addReferredFrom(Party vet, Date start) {
        return this.addReferredFrom(vet, start, null);
    }

    public TestPatientBuilder addReferredFrom(Party vet, Date start, String reason) {
        this.referrals.add(new Referral(vet, true, start, reason));
        return this;
    }

    public TestPatientBuilder addReferredTo(Party vet) {
        return this.addReferredTo(vet, new Date());
    }

    public TestPatientBuilder addReferredTo(Party vet, Date start) {
        return this.addReferredTo(vet, start, null);
    }

    public TestPatientBuilder addReferredTo(Party vet, Date start, String reason) {
        this.referrals.add(new Referral(vet, false, start, reason));
        return this;
    }

    @Override
    protected void build(Party object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        EntityIdentity identity;
        super.build(object, bean, toSave, toRemove);
        ArchetypeService service = this.getService();
        Lookup speciesLookup = null;
        if (this.species.isSet()) {
            TestLookupBuilder speciesBuilder = new TestLookupBuilder("lookup.species", service);
            speciesLookup = (Lookup)((TestLookupBuilder)speciesBuilder.code(this.species)).build();
            bean.setValue("species", (Object)speciesLookup.getCode());
        }
        if (this.breed.isSet()) {
            if (this.breed.getValue() != null) {
                if (speciesLookup == null) {
                    speciesLookup = bean.getLookup("species");
                }
                TestLookupBuilder breedBuilder = new TestLookupBuilder("lookup.breed", service);
                Lookup breedLookup = (Lookup)((TestLookupBuilder)((TestLookupBuilder)breedBuilder.code(this.breed)).source(speciesLookup)).build();
                bean.setValue("breed", (Object)breedLookup.getCode());
            } else {
                this.breed.setValue(bean, "breed");
            }
        }
        this.newBreed.setValue(bean, "newBreed");
        this.sex.setValue(bean, "sex");
        this.desexed.setValue(bean, "desexed");
        this.dateOfBirth.setValue(bean, "dateOfBirth");
        this.deceased.setValue(bean, "deceased");
        this.dateOfDeath.setValue(bean, "deceasedDate");
        this.colour.setValue(bean, "colour");
        if (this.cageCode.isSet()) {
            if (this.cageCode.getValue() != null) {
                TestLookupBuilder cageBuilder = new TestLookupBuilder("lookup.cage", service);
                Lookup cageLookup = (Lookup)((TestLookupBuilder)cageBuilder.code(this.cageCode)).build();
                bean.setValue("cage", (Object)cageLookup.getCode());
            } else {
                this.cageCode.setValue(bean, "cage");
            }
        }
        if (!this.owners.isEmpty()) {
            for (CustomerRelationship owner : this.owners) {
                IMObjectBean ownerBean = service.getBean((IMObject)owner.customer);
                EntityRelationship entityRelationship = (EntityRelationship)ownerBean.addTarget("patients", "entityRelationship.patientOwner", (IMObject)object, "customers");
                entityRelationship.setActiveStartTime(owner.startTime);
                entityRelationship.setActiveEndTime(owner.endTime);
                toSave.add((IMObject)owner.customer);
            }
            this.setEndDates(bean.getValues("customers", PeriodRelationship.class, Predicates.isA((String[])new String[]{"entityRelationship.patientOwner"})));
        }
        if (!this.locations.isEmpty()) {
            for (CustomerRelationship location : this.locations) {
                IMObjectBean locationBean = service.getBean((IMObject)location.customer);
                EntityRelationship entityRelationship = (EntityRelationship)locationBean.addTarget("patients", "entityRelationship.patientLocation", (IMObject)object, "customers");
                entityRelationship.setActiveStartTime(location.startTime);
                entityRelationship.setActiveEndTime(location.endTime);
                toSave.add((IMObject)location.customer);
            }
            this.setEndDates(bean.getValues("customers", PeriodRelationship.class, Predicates.isA((String[])new String[]{"entityRelationship.patientLocation"})));
        }
        for (String microchip : this.microchips) {
            identity = new TestEntityIdentityBuilder("entityIdentity.microchip", this.getService()).identity(microchip).build();
            object.addIdentity(identity);
        }
        for (String petTag : this.petTags) {
            identity = new TestEntityIdentityBuilder("entityIdentity.petTag", this.getService()).identity(petTag).build();
            object.addIdentity(identity);
        }
        for (String rabiesTag : this.rabiesTags) {
            identity = new TestEntityIdentityBuilder("entityIdentity.rabiesTag", this.getService()).identity(rabiesTag).build();
            object.addIdentity(identity);
        }
        for (String alias : this.aliases) {
            identity = new TestEntityIdentityBuilder("entityIdentity.alias", this.getService()).identity(alias).build();
            object.addIdentity(identity);
        }
        if (this.discounts != null) {
            for (Iterator<Object> iterator : this.discounts) {
                bean.addTarget("discounts", iterator);
            }
        }
        if (!this.referrals.isEmpty()) {
            for (Referral referral : this.referrals) {
                String archetype = referral.from ? "entityRelationship.referredFrom" : "entityRelationship.referredTo";
                Party party = referral.vet;
                EntityRelationship relationship2 = (EntityRelationship)bean.addTarget("referrals", archetype, (IMObject)party);
                relationship2.setActiveStartTime(referral.start);
                this.getBean((IMObject)relationship2).setValue("reason", (Object)referral.reason);
                party.addEntityRelationship(relationship2);
                toSave.add((IMObject)party);
            }
            this.setEndDates(bean.getValues("referrals", PeriodRelationship.class));
        }
    }

    private static class Referral {
        private final Party vet;
        private final boolean from;
        private final Date start;
        private final String reason;

        public Referral(Party vet, boolean from, Date start, String reason) {
            this.vet = vet;
            this.from = from;
            this.start = start;
            this.reason = reason;
        }
    }

    private static class CustomerRelationship {
        private final Party customer;
        private final Date startTime;
        private final Date endTime;

        public CustomerRelationship(Party customer, Date startTime, Date endTime) {
            this.customer = customer;
            this.startTime = startTime;
            this.endTime = endTime;
        }
    }
}

