/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.patient;

import java.util.Set;
import org.openvpms.archetype.test.builder.act.AbstractTestActBuilder;
import org.openvpms.archetype.test.builder.act.LongTextBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.patient.TestInvestigationResultsBuilder;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestInvestigationResultBuilder
extends AbstractTestActBuilder<Act, TestInvestigationResultBuilder> {
    private final TestInvestigationResultsBuilder parent;
    private final LongTextBuilder resultBuilder;
    private final LongTextBuilder notesBuilder;
    private ValueStrategy resultId = ValueStrategy.unset();
    private ValueStrategy result = ValueStrategy.unset();
    private ValueStrategy notes = ValueStrategy.unset();
    private ValueStrategy image = ValueStrategy.unset();

    public TestInvestigationResultBuilder(TestInvestigationResultsBuilder parent, ArchetypeService service) {
        super("act.patientInvestigationResultItem", Act.class, service);
        this.parent = parent;
        this.resultBuilder = new LongTextBuilder("result", "longResult", service);
        this.notesBuilder = new LongTextBuilder("notes", "longNotes", service);
    }

    public TestInvestigationResultBuilder resultId(String resultId) {
        this.resultId = ValueStrategy.value(resultId);
        return this;
    }

    public TestInvestigationResultBuilder result(String result) {
        this.result = ValueStrategy.value(result);
        return this;
    }

    public TestInvestigationResultBuilder notes(String notes) {
        this.notes = ValueStrategy.value(notes);
        return this;
    }

    public TestInvestigationResultBuilder image(Document image) {
        this.image = ValueStrategy.value(image);
        return this;
    }

    public TestInvestigationResultsBuilder add() {
        this.parent.addResult(this);
        return this.parent;
    }

    @Override
    protected void build(Act object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        this.resultId.setValue(bean, "resultId");
        this.resultBuilder.build(this.result, bean, toSave, toRemove);
        this.notesBuilder.build(this.notes, bean, toSave, toRemove);
        if (this.image.isSet()) {
            Document newImage;
            DocumentAct imageAct = (DocumentAct)bean.getTarget("image", DocumentAct.class);
            if (imageAct != null && imageAct.getDocument() != null) {
                toRemove.add(imageAct.getObjectReference());
            }
            if ((newImage = (Document)this.image.getValue()) == null) {
                if (imageAct != null) {
                    toRemove.add(imageAct.getObjectReference());
                }
            } else {
                toSave.add((IMObject)newImage);
                if (imageAct == null) {
                    imageAct = this.create("act.patientInvestigationResultImage", DocumentAct.class);
                    bean.addTarget("image", (IMObject)imageAct, "parent");
                    toSave.add((IMObject)imageAct);
                }
                imageAct.setDocument(newImage.getObjectReference());
            }
        }
    }
}

