/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.object;

import java.math.BigDecimal;
import java.util.Date;
import org.junit.Assert;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.AuditableIMObject;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Identity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;

public abstract class AbstractTestIMObjectVerifier<T extends IMObject, V extends AbstractTestIMObjectVerifier<T, V>> {
    private final ArchetypeService service;
    private ValueStrategy archetype = ValueStrategy.unset();
    private ValueStrategy createdBy = ValueStrategy.unset();

    public AbstractTestIMObjectVerifier(ArchetypeService service) {
        this.service = service;
    }

    public V archetype(String archetype) {
        this.archetype = ValueStrategy.value(archetype);
        return this.getThis();
    }

    public V createdBy(User createdBy) {
        return this.createdBy(this.getReference((IMObject)createdBy));
    }

    public V createdBy(Reference createdBy) {
        this.createdBy = ValueStrategy.value(createdBy);
        return this.getThis();
    }

    public void verify(T object) {
        this.verify(object, this.getBean((IMObject)object));
    }

    protected void verify(T object, IMObjectBean bean) {
        if (this.archetype.isSet()) {
            Assert.assertTrue((boolean)object.isA(this.archetype.toString()));
        }
        if (object instanceof AuditableIMObject) {
            this.checkEquals(this.createdBy, ((AuditableIMObject)object).getCreatedBy());
        } else {
            Assert.assertNull((Object)this.createdBy.getValue());
        }
    }

    protected ArchetypeService getService() {
        return this.service;
    }

    protected IMObjectBean getBean(IMObject object) {
        return this.service.getBean(object);
    }

    protected Reference getReference(IMObject object) {
        return object != null ? object.getObjectReference() : null;
    }

    protected V getThis() {
        return (V)this;
    }

    protected void checkEquals(ValueStrategy expected, Object actual) {
        if (expected.isSet()) {
            Object value = expected.getValue();
            if (actual instanceof BigDecimal) {
                if (value instanceof Integer) {
                    this.checkEquals((Integer)value, (BigDecimal)actual);
                } else if (value instanceof String) {
                    this.checkEquals((String)value, (BigDecimal)actual);
                } else {
                    this.checkEquals((BigDecimal)value, (BigDecimal)actual);
                }
            } else {
                Assert.assertEquals((Object)expected.getValue(), (Object)actual);
            }
        }
    }

    protected void checkEquals(String expected, BigDecimal actual) {
        this.checkEquals(new BigDecimal(expected), actual);
    }

    protected void checkEquals(int expected, BigDecimal actual) {
        this.checkEquals(BigDecimal.valueOf(expected), actual);
    }

    protected void checkEquals(BigDecimal expected, BigDecimal actual) {
        TestHelper.checkEquals(expected, actual);
    }

    protected void checkEquals(ValueStrategy expected, Date actual) {
        if (expected.isSet()) {
            Assert.assertEquals((long)0L, (long)DateRules.compareTo((Date)((Date)expected.getValue()), (Date)actual, (boolean)true));
        }
    }

    protected void checkTargetEquals(ValueStrategy expected, IMObjectBean bean, String node) {
        if (expected.isSet()) {
            Assert.assertEquals((Object)expected.getValue(), (Object)bean.getTargetRef(node));
        }
    }

    protected void checkIdentityEquals(ValueStrategy expected, IMObjectBean bean, String node) {
        if (expected.isSet()) {
            Identity identity = (Identity)bean.getObject(node, Identity.class);
            String value = expected.toString();
            if (identity == null) {
                Assert.assertNull((Object)value);
            } else {
                Assert.assertEquals((Object)value, (Object)identity.getIdentity());
            }
        }
    }
}

