/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.object;

import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.Assert;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.entity.TestEntityIdentityBuilder;
import org.openvpms.archetype.test.builder.object.BuiltObjects;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.singleton.SingletonQuery;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.archetype.NodeDescriptor;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.EntityIdentity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.SequencedRelationship;
import org.openvpms.component.service.archetype.ArchetypeService;

public class AbstractTestIMObjectBuilder<T extends IMObject, B extends AbstractTestIMObjectBuilder<T, B>> {
    private final T existing;
    private final String archetype;
    private final Class<T> type;
    private final ArchetypeService service;
    private final Set<IMObject> collector = new LinkedHashSet<IMObject>();
    private BuiltObjects builtObjects;
    private ValueStrategy name = ValueStrategy.unset();
    private ValueStrategy description = ValueStrategy.unset();
    private Boolean active;

    public AbstractTestIMObjectBuilder(Class<T> type, ArchetypeService service) {
        this(null, null, type, service);
    }

    public AbstractTestIMObjectBuilder(String archetype, Class<T> type, ArchetypeService service) {
        this(null, archetype, type, service);
    }

    public AbstractTestIMObjectBuilder(T object, ArchetypeService service) {
        this(object, object.getArchetype(), object.getClass(), service);
    }

    private AbstractTestIMObjectBuilder(T object, String archetype, Class<T> type, ArchetypeService service) {
        this.existing = object;
        this.archetype = archetype;
        this.type = type;
        this.service = service;
    }

    public B name(String name) {
        return this.name(ValueStrategy.value(name));
    }

    public B name(ValueStrategy name) {
        this.name = name;
        return this.getThis();
    }

    public B description(String description) {
        return this.description(ValueStrategy.value(description));
    }

    public B description(ValueStrategy description) {
        this.description = description;
        return this.getThis();
    }

    public B active(boolean active) {
        this.active = active;
        return this.getThis();
    }

    public B collect(Collection<IMObject> objects) {
        this.collector.addAll(objects);
        return this.getThis();
    }

    public T build() {
        return this.build(true);
    }

    public T build(boolean save) {
        LinkedHashSet<IMObject> toSave = new LinkedHashSet<IMObject>();
        LinkedHashSet<Reference> remove = new LinkedHashSet<Reference>();
        T entity = this.build(toSave, remove);
        if (save) {
            this.service.save(toSave);
            for (Reference reference : remove) {
                this.service.remove(reference);
            }
        } else {
            for (IMObject object : toSave) {
                this.service.deriveValues(object);
            }
        }
        this.builtObjects = new BuiltObjects((IMObject)entity, (Set<IMObject>)toSave);
        return entity;
    }

    public T build(Set<IMObject> objects, Set<Reference> remove) {
        T entity = this.getObject(this.archetype);
        IMObjectBean bean = this.service.getBean(entity);
        this.build(entity, bean, objects, remove);
        objects.add((IMObject)entity);
        if (!this.collector.isEmpty()) {
            objects.addAll(this.collector);
            this.collector.clear();
        }
        return entity;
    }

    public BuiltObjects getBuiltObjects() {
        return this.builtObjects;
    }

    protected T getObject(String archetype) {
        Object result = this.existing != null && this.existing.isA(archetype) ? this.existing : this.service.create(archetype, this.type);
        return (T)result;
    }

    protected T getExisting() {
        return this.existing;
    }

    protected void build(T object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        this.name.setValue(bean, "name");
        this.description.setValue(bean, "description");
        if (this.active != null) {
            object.setActive(this.active.booleanValue());
        }
    }

    protected ValueStrategy getName() {
        return this.name;
    }

    protected B getThis() {
        return (B)this;
    }

    protected ArchetypeService getService() {
        return this.service;
    }

    protected IMObjectBean getBean(IMObject object) {
        return this.service.getBean(object);
    }

    protected <O extends IMObject> O create(String archetype, Class<O> type) {
        return (O)this.service.create(archetype, type);
    }

    protected <O extends IMObject> O getSingleton(String archetype, Class<O> type) {
        IMObject result = new SingletonQuery(this.getService()).get(archetype, type);
        if (result == null) {
            result = this.service.create(archetype, type);
        }
        return (O)result;
    }

    protected EntityIdentity createEntityIdentity(String archetype, ValueStrategy id) {
        return this.newEntityIdentity(archetype).identity(id).build();
    }

    protected TestEntityIdentityBuilder newEntityIdentity(String archetype) {
        return new TestEntityIdentityBuilder(archetype, this.service);
    }

    protected ActIdentity createActIdentity(String archetype, String id) {
        ActIdentity identity = this.create(archetype, ActIdentity.class);
        identity.setIdentity(id);
        return identity;
    }

    protected ActIdentity createActIdentity(String archetype, ValueStrategy id) {
        ActIdentity identity = this.create(archetype, ActIdentity.class);
        id.setValue(this.getBean((IMObject)identity), "identity");
        return identity;
    }

    protected String[] getArchetypeRange(String node) {
        ArchetypeDescriptor archetypeDescriptor = DescriptorHelper.getArchetypeDescriptor((String)this.archetype, (ArchetypeService)this.service);
        Assert.assertNotNull((Object)archetypeDescriptor);
        NodeDescriptor nodeDescriptor = archetypeDescriptor.getNodeDescriptor(node);
        Assert.assertNotNull((Object)nodeDescriptor);
        return DescriptorHelper.getShortNames((NodeDescriptor)nodeDescriptor, (ArchetypeService)this.service);
    }

    protected String getNodeArchetype(String node) {
        String[] range = this.getArchetypeRange(node);
        if (range.length != 1) {
            throw new IllegalStateException("Archetype range must return 1 archetype for node=" + node + " of archetype=" + this.archetype + " but returned: " + ArrayUtils.toString((Object)range));
        }
        return range[0];
    }

    protected int getNextSequence(IMObjectBean bean, String node) {
        return bean.getValues(node, SequencedRelationship.class).stream().map(SequencedRelationship::getSequence).max(Comparator.naturalOrder()).map(value -> value + 1).orElse(0);
    }

    protected Date parseDate(String value) {
        return TestHelper.parseDate(value);
    }
}

