/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.lookup;

import java.math.BigDecimal;
import org.openvpms.archetype.test.builder.lookup.TestBreedBuilder;
import org.openvpms.archetype.test.builder.lookup.TestCountryBuilder;
import org.openvpms.archetype.test.builder.lookup.TestCurrencyBuilder;
import org.openvpms.archetype.test.builder.lookup.TestLookupBuilder;
import org.openvpms.archetype.test.builder.lookup.TestMacroBuilder;
import org.openvpms.archetype.test.builder.lookup.TestSpeciesBuilder;
import org.openvpms.archetype.test.builder.lookup.TestStateBuilder;
import org.openvpms.archetype.test.builder.lookup.TestSuburbBuilder;
import org.openvpms.archetype.test.builder.lookup.TestTaxTypeBuilder;
import org.openvpms.archetype.test.builder.lookup.TestUnitOfMeasureBuilder;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestLookupFactory {
    private final ArchetypeService service;

    public TestLookupFactory(ArchetypeService service) {
        this.service = service;
    }

    public Lookup getLookup(String archetype, String code) {
        return (Lookup)((TestLookupBuilder)this.newLookup(archetype).code(code)).build();
    }

    public Lookup getLookup(String archetype, String code, String name) {
        return (Lookup)((TestLookupBuilder)((TestLookupBuilder)this.newLookup(archetype).code(code)).name(name)).build();
    }

    public Lookup getBreed(String breed) {
        return (Lookup)((TestBreedBuilder)this.newBreed().code(breed)).build();
    }

    public Lookup getBreed(String breed, String species) {
        return (Lookup)((TestBreedBuilder)this.newBreed().code(breed)).species(this.getSpecies(species)).build();
    }

    public TestBreedBuilder newBreed() {
        return new TestBreedBuilder(this.service);
    }

    public Lookup getCountry(String code) {
        return (Lookup)((TestCountryBuilder)this.newCountry().code(code)).build();
    }

    public TestCountryBuilder newCountry() {
        return new TestCountryBuilder(this.service);
    }

    public Lookup getState(String code, String name) {
        return (Lookup)((TestStateBuilder)((TestStateBuilder)this.newState().code(code)).name(name)).build();
    }

    public TestStateBuilder newState() {
        return new TestStateBuilder(this.service);
    }

    public Lookup getSuburb(String code, String name, String postcode, String stateCode) {
        return (Lookup)((TestSuburbBuilder)((TestSuburbBuilder)((TestSuburbBuilder)this.newSuburb().code(code)).name(name)).postcode(postcode).source(this.getLookup("lookup.state", stateCode))).build();
    }

    public TestSuburbBuilder newSuburb() {
        return new TestSuburbBuilder(this.service);
    }

    public Lookup getCurrency(String code) {
        return (Lookup)((TestCurrencyBuilder)this.newCurrency().code(code)).build();
    }

    public TestCurrencyBuilder newCurrency() {
        return new TestCurrencyBuilder(this.service);
    }

    public Lookup getSpecies(String code) {
        return (Lookup)((TestSpeciesBuilder)this.newSpecies().code(code)).build();
    }

    public TestSpeciesBuilder newSpecies() {
        return new TestSpeciesBuilder(this.service);
    }

    public Lookup getMacro(String code, String expression) {
        return (Lookup)((TestMacroBuilder)this.newMacro().code(code)).expression(expression).build();
    }

    public TestMacroBuilder newMacro() {
        return new TestMacroBuilder(this.service);
    }

    public Lookup createTaxType(int rate) {
        return (Lookup)this.newTaxType().rate(rate).build();
    }

    public Lookup createTaxType(BigDecimal rate) {
        return (Lookup)this.newTaxType().rate(rate).build();
    }

    public TestTaxTypeBuilder newTaxType() {
        return new TestTaxTypeBuilder(this.service);
    }

    public Lookup createUnitOfMeasure(String code) {
        return this.createUnitOfMeasure(code, null);
    }

    public Lookup createUnitOfMeasure(String code, String unitCode) {
        return (Lookup)((TestUnitOfMeasureBuilder)new TestUnitOfMeasureBuilder(this.service).code(code)).unitCode(unitCode).build();
    }

    public Lookup createLookup(String archetype, String code) {
        return this.createLookup(archetype, code, false);
    }

    public Lookup createLookup(String archetype, String code, String name) {
        return (Lookup)((TestLookupBuilder)((TestLookupBuilder)((TestLookupBuilder)this.newLookup(archetype).code(code)).name(name)).isDefault(false)).build();
    }

    public Lookup createLookup(String archetype, String code, boolean isDefault) {
        return (Lookup)((TestLookupBuilder)((TestLookupBuilder)new TestLookupBuilder(archetype, this.service).code(code)).isDefault(isDefault)).build();
    }

    public TestLookupBuilder newLookup(String archetype) {
        return new TestLookupBuilder(archetype, this.service);
    }

    public void clearDefault(String archetype) {
        TestLookupBuilder.clearDefault(archetype, this.service);
    }
}

