/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.lookup;

import java.math.BigDecimal;
import java.util.Set;
import org.openvpms.archetype.rules.finance.account.AccountType;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.lookup.AbstractTestLookupBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestCustomerAccountTypeBuilder
extends AbstractTestLookupBuilder<TestCustomerAccountTypeBuilder> {
    private ValueStrategy paymentTerms = ValueStrategy.unset();
    private ValueStrategy paymentTermsUnits = ValueStrategy.unset();
    private ValueStrategy accountFeeAmount = ValueStrategy.unset();
    private ValueStrategy accountFeeType = ValueStrategy.unset();
    private ValueStrategy accountFeeDays = ValueStrategy.unset();
    private ValueStrategy accountFeeBalance = ValueStrategy.unset();
    private ValueStrategy accountFeeMessage = ValueStrategy.unset();

    public TestCustomerAccountTypeBuilder(ArchetypeService service) {
        super("lookup.customerAccountType", service);
        this.code(ValueStrategy.random("ZACCOUNT_TYPE").toString());
    }

    public TestCustomerAccountTypeBuilder paymentTerms(int terms, DateUnits units) {
        this.paymentTerms = ValueStrategy.value(terms);
        this.paymentTermsUnits = ValueStrategy.value(units.toString());
        return this;
    }

    public TestCustomerAccountTypeBuilder accountFee(int amount, AccountType.FeeType feeType) {
        return this.accountFee(BigDecimal.valueOf(amount), feeType);
    }

    public TestCustomerAccountTypeBuilder accountFee(BigDecimal amount, AccountType.FeeType feeType) {
        this.accountFeeAmount = ValueStrategy.value(amount);
        this.accountFeeType = ValueStrategy.value(feeType.toString());
        return this;
    }

    public TestCustomerAccountTypeBuilder accountFeeDays(int accountFeeDays) {
        this.accountFeeDays = ValueStrategy.value(accountFeeDays);
        return this;
    }

    public TestCustomerAccountTypeBuilder accountFeeBalance(int accountFeeBalance) {
        return this.accountFeeBalance(BigDecimal.valueOf(accountFeeBalance));
    }

    public TestCustomerAccountTypeBuilder accountFeeBalance(BigDecimal accountFeeBalance) {
        this.accountFeeBalance = ValueStrategy.value(accountFeeBalance);
        return this;
    }

    public TestCustomerAccountTypeBuilder accountFeeMessage(String accountFeeMessage) {
        this.accountFeeMessage = ValueStrategy.value(accountFeeMessage);
        return this;
    }

    @Override
    protected void build(Lookup object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        this.paymentTerms.setValue(bean, "paymentTerms");
        this.paymentTermsUnits.setValue(bean, "paymentUom");
        this.accountFeeType.setValue(bean, "accountFee");
        this.accountFeeAmount.setValue(bean, "accountFeeAmount");
        this.accountFeeDays.setValue(bean, "accountFeeDays");
        this.accountFeeBalance.setValue(bean, "accountFeeBalance");
        this.accountFeeMessage.setValue(bean, "accountFeeMessage");
    }
}

