/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.laboratory;

import java.util.Set;
import org.openvpms.archetype.test.builder.entity.AbstractTestEntityBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestHL7LaboratoryBuilder
extends AbstractTestEntityBuilder<Entity, TestHL7LaboratoryBuilder> {
    private Entity sender;
    private Party location;
    private User user;

    public TestHL7LaboratoryBuilder(ArchetypeService service) {
        super("entity.HL7ServiceLaboratory", Entity.class, service);
        this.name(ValueStrategy.random("zhl7"));
    }

    public TestHL7LaboratoryBuilder sender(Entity sender) {
        this.sender = sender;
        return this;
    }

    public TestHL7LaboratoryBuilder location(Party location) {
        this.location = location;
        return this;
    }

    public TestHL7LaboratoryBuilder user(User user) {
        this.user = user;
        return this;
    }

    @Override
    protected void build(Entity object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.sender != null) {
            bean.setTarget("sender", (IMObject)this.sender);
        }
        if (this.location != null) {
            bean.setTarget("location", (IMObject)this.location);
        }
        if (this.user != null) {
            bean.setTarget("user", (IMObject)this.user);
        }
    }
}

