/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.laboratory;

import java.math.BigDecimal;
import java.util.Set;
import org.openvpms.archetype.test.builder.entity.AbstractTestEntityBuilder;
import org.openvpms.archetype.test.builder.entity.TestEntityIdentityBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityIdentity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class AbstractTestLaboratoryTestBuilder<B extends AbstractTestLaboratoryTestBuilder<B>>
extends AbstractTestEntityBuilder<Entity, B> {
    private String testCodeArchetype;
    private ValueStrategy testCode;
    private String testCodeValue;
    private ValueStrategy testCodeName = ValueStrategy.unset();
    private ValueStrategy price = ValueStrategy.unset();
    private Entity investigationType;
    private ValueStrategy group = ValueStrategy.unset();

    public AbstractTestLaboratoryTestBuilder(String archetype, ArchetypeService service) {
        super(archetype, Entity.class, service);
    }

    public B code(String archetype, String code) {
        return this.code(archetype, ValueStrategy.value(code));
    }

    public B code(String archetype, ValueStrategy code) {
        this.testCodeArchetype = archetype;
        this.testCode = code;
        return (B)((AbstractTestLaboratoryTestBuilder)this.getThis());
    }

    public B code(String archetype, String code, String name) {
        this.code(archetype, code);
        this.testCodeName = ValueStrategy.value(name);
        return (B)((AbstractTestLaboratoryTestBuilder)this.getThis());
    }

    public String getTestCode() {
        return this.testCodeValue;
    }

    public B price(int price) {
        return this.price(BigDecimal.valueOf(price));
    }

    public B price(BigDecimal price) {
        this.price = ValueStrategy.value(price);
        return (B)((AbstractTestLaboratoryTestBuilder)this.getThis());
    }

    public B investigationType(Entity investigationType) {
        this.investigationType = investigationType;
        return (B)((AbstractTestLaboratoryTestBuilder)this.getThis());
    }

    public B group(boolean group) {
        this.group = ValueStrategy.value(group);
        return (B)((AbstractTestLaboratoryTestBuilder)this.getThis());
    }

    @Override
    protected void build(Entity object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.testCode != null) {
            EntityIdentity identity = ((TestEntityIdentityBuilder)this.newEntityIdentity(this.testCodeArchetype).identity(this.testCode).name(this.testCodeName)).build();
            object.addIdentity(identity);
            this.testCodeValue = identity.getIdentity();
        } else {
            this.testCodeValue = null;
        }
        this.price.setValue(bean, "price");
        if (this.investigationType != null) {
            bean.setTarget("investigationType", (IMObject)this.investigationType);
        }
        this.group.setValue(bean, "group");
    }
}

